/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.service.jmx.handler.notification;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jolokia.server.core.http.BackChannel;
import org.jolokia.server.core.http.BackChannelHolder;
import org.jolokia.server.core.request.EmptyResponseException;
import org.jolokia.server.core.request.notification.AddCommand;
import org.jolokia.server.core.request.notification.OpenCommand;
import org.jolokia.server.core.service.notification.BackendCallback;
import org.jolokia.server.core.service.notification.Client;
import org.jolokia.server.core.service.notification.ListenerRegistration;
import org.jolokia.server.core.service.notification.NotificationBackend;
import org.jolokia.server.core.service.notification.NotificationBackendManager;
import org.jolokia.server.core.service.notification.NotificationSubscription;
import org.jolokia.server.core.util.jmx.MBeanServerAccess;
import org.jolokia.service.jmx.handler.notification.NotificationSubscriptionImpl;
import org.json.simple.JSONObject;

class NotificationListenerDelegate
implements NotificationListener {
    private Map<String, Client> clients;
    private final NotificationBackendManager backendManager;

    NotificationListenerDelegate(NotificationBackendManager pBackendManager) {
        this.backendManager = pBackendManager;
        this.clients = new HashMap<String, Client>();
    }

    String register() {
        String uuid = this.createClientId();
        this.clients.put(uuid, new Client(uuid));
        return uuid;
    }

    void unregister(MBeanServerAccess pExecutor, String pClient) throws MBeanException, IOException, ReflectionException {
        Client client = this.getClient(pClient);
        for (String handle : client.getHandles()) {
            this.removeListener(pExecutor, pClient, handle);
        }
        this.clients.remove(pClient);
        this.backendManager.unregister(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String addListener(MBeanServerAccess pExecutor, AddCommand pCommand) throws MBeanException, IOException, ReflectionException {
        Client client = this.getClient(pCommand.getClient());
        NotificationBackend backend = this.backendManager.getBackend(pCommand.getMode());
        Client client2 = client;
        synchronized (client2) {
            String handle = client.getNextHandle();
            NotificationSubscriptionImpl notificationSubscription = new NotificationSubscriptionImpl(handle, pCommand, client, this);
            BackendCallback callback = backend.subscribe((NotificationSubscription)notificationSubscription);
            final ListenerRegistration listenerRegistration = new ListenerRegistration(pCommand, callback);
            client.addUsedBackend(pCommand.getMode());
            client.addNotification(handle, listenerRegistration);
            final boolean[] added = new boolean[]{false};
            try {
                pExecutor.each(listenerRegistration.getMBeanName(), new MBeanServerAccess.MBeanEachCallback(){

                    public void callback(MBeanServerConnection pConn, ObjectName pName) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException {
                        pConn.addNotificationListener(pName, NotificationListenerDelegate.this, listenerRegistration.getFilter(), (Object)listenerRegistration);
                        added[0] = true;
                    }
                });
            }
            finally {
                if (!added[0]) {
                    client.remove(handle);
                }
            }
            return handle;
        }
    }

    void removeListener(MBeanServerAccess pExecutor, String pClient, String pHandle) throws MBeanException, IOException, ReflectionException {
        Client client = this.getClient(pClient);
        final ListenerRegistration registration = client.get(pHandle);
        pExecutor.each(registration.getMBeanName(), new MBeanServerAccess.MBeanEachCallback(){

            public void callback(MBeanServerConnection pConn, ObjectName pName) throws ReflectionException, InstanceNotFoundException, IOException, MBeanException {
                try {
                    pConn.removeNotificationListener(pName, NotificationListenerDelegate.this, registration.getFilter(), (Object)registration);
                }
                catch (ListenerNotFoundException listenerNotFoundException) {
                    // empty catch block
                }
            }
        });
        client.remove(pHandle);
        this.backendManager.unsubscribe(registration.getBackendMode(), pClient, pHandle);
    }

    void refresh(String pClient) {
        Client client = this.getClient(pClient);
        client.refresh();
    }

    void cleanup(MBeanServerAccess pExecutor, long pOldest) throws MBeanException, IOException, ReflectionException {
        for (Map.Entry<String, Client> client : this.clients.entrySet()) {
            if (client.getValue().getLastRefresh() >= pOldest) continue;
            this.unregister(pExecutor, client.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openChannel(OpenCommand pCommand) throws IOException, EmptyResponseException {
        String clientId = pCommand.getClient();
        Client client = this.getClient(clientId);
        String mode = pCommand.getMode();
        Client client2 = client;
        synchronized (client2) {
            BackChannel channel = client.getBackChannel(mode);
            if (channel != null) {
                channel.close();
            }
            NotificationBackend backend = this.backendManager.getBackend(mode);
            channel = BackChannelHolder.get();
            channel.open(backend.getConfig());
            backend.channelInit(client, channel);
            client.setBackChannel(mode, channel);
        }
        throw new EmptyResponseException();
    }

    JSONObject list(String pClient) {
        Client client = this.getClient(pClient);
        return client.list();
    }

    public void handleNotification(Notification notification, Object handback) {
        ListenerRegistration registration = (ListenerRegistration)handback;
        BackendCallback callback = registration.getCallback();
        callback.handleNotification(notification, registration.getHandback());
    }

    private String createClientId() {
        return UUID.randomUUID().toString();
    }

    private Client getClient(String pClient) {
        Client client = this.clients.get(pClient);
        if (client == null) {
            throw new IllegalArgumentException("No client " + pClient + " registered");
        }
        return client;
    }
}

