/*
 * Decompiled with CFR 0.152.
 */
package org.jooby.assets;

import com.google.common.collect.ImmutableList;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigValueFactory;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jooby.Route;
import org.jooby.internal.RoutePattern;

public class AssetOptions {
    private Config options = ConfigFactory.empty();

    public AssetOptions set(String name, Object value) {
        Objects.requireNonNull(name, "Option's name is required.");
        this.options = this.options.withValue(name, ConfigValueFactory.fromAnyRef((Object)value));
        return this;
    }

    public AssetOptions set(Config options) {
        this.options = Objects.requireNonNull(options, "Options are required.").withFallback((ConfigMergeable)this.options);
        return this;
    }

    public Map<String, Object> options() throws Exception {
        return this.options.withoutPath("excludes").root().unwrapped();
    }

    public boolean excludes(String path) {
        Object value = this.get("excludes");
        if (value == null) {
            return false;
        }
        List excludes = value instanceof List ? (List)value : ImmutableList.of((Object)value.toString());
        String spath = Route.normalize((String)path);
        return excludes.stream().map(it -> new RoutePattern("GET", it)).filter(pattern -> pattern.matcher("GET" + spath).matches()).findFirst().isPresent();
    }

    public <T> T get(String name) {
        Objects.requireNonNull(name, "Option's name is required.");
        if (this.options.hasPath(name)) {
            return (T)this.options.getAnyRef(name);
        }
        return null;
    }
}

