/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import java.util.Arrays;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.NormDiscrete;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.CategoricalFeature;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;

public class BooleanFeature
extends CategoricalFeature
implements HasDerivedName {
    public BooleanFeature(PMMLEncoder encoder, TypeDefinitionField field) {
        super(encoder, field, Arrays.asList("false", "true"));
    }

    @Override
    public FieldName getDerivedName() {
        return FieldName.create((String)(this.getName().getValue() + "=true"));
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        FieldName derivedName;
        PMMLEncoder encoder = this.ensureEncoder();
        DerivedField derivedField = encoder.getDerivedField(derivedName = this.getDerivedName());
        if (derivedField == null) {
            NormDiscrete normDiscrete = new NormDiscrete(this.getName(), "true");
            derivedField = encoder.createDerivedField(derivedName, OpType.CONTINUOUS, DataType.DOUBLE, (Expression)normDiscrete);
        }
        return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
    }
}

