/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Objects;
import java.util.Objects;
import org.dmg.pmml.Constant;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;

public class ConstantFeature
extends Feature
implements HasDerivedName {
    private Number value = null;

    public ConstantFeature(PMMLEncoder encoder, Number value) {
        super(encoder, ConstantFeature.getName(value), ConstantFeature.getDataType(value));
        this.setValue(value);
    }

    @Override
    public FieldName getDerivedName() {
        return FieldName.create((String)("constant(" + this.getName().getValue() + ")"));
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        FieldName derivedName;
        PMMLEncoder encoder = this.ensureEncoder();
        DerivedField derivedField = encoder.getDerivedField(derivedName = this.getDerivedName());
        if (derivedField == null) {
            Constant constant = PMMLUtil.createConstant(this.getValue());
            derivedField = encoder.createDerivedField(derivedName, OpType.CONTINUOUS, this.getDataType(), (Expression)constant);
        }
        return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getValue());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ConstantFeature) {
            ConstantFeature that = (ConstantFeature)object;
            return super.equals(object) && Objects.equals(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("value", (Object)this.getValue());
    }

    public Number getValue() {
        return this.value;
    }

    private void setValue(Number value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        this.value = value;
    }

    private static FieldName getName(Number number) {
        if (number instanceof Integer || number instanceof Long) {
            return FieldName.create((String)number.toString());
        }
        if (number instanceof Float) {
            return FieldName.create((String)(number.toString() + "f"));
        }
        if (number instanceof Double) {
            return FieldName.create((String)number.toString());
        }
        throw new IllegalArgumentException();
    }

    private static DataType getDataType(Number number) {
        if (number instanceof Integer || number instanceof Long) {
            return DataType.INTEGER;
        }
        if (number instanceof Float) {
            return DataType.FLOAT;
        }
        if (number instanceof Double) {
            return DataType.DOUBLE;
        }
        throw new IllegalArgumentException();
    }
}

