/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.jpmml.converter.AbstractTransformation;
import org.jpmml.converter.PMMLUtil;

public class FunctionTransformation
extends AbstractTransformation {
    private String function = null;

    public FunctionTransformation(String function) {
        this.setFunction(function);
    }

    @Override
    public FieldName getName(FieldName name) {
        String function = this.getFunction();
        return FunctionTransformation.withPrefix(name, function);
    }

    @Override
    public Expression createExpression(FieldRef fieldRef) {
        String function = this.getFunction();
        return PMMLUtil.createApply(function, new Expression[]{fieldRef});
    }

    public String getFunction() {
        return this.function;
    }

    private void setFunction(String function) {
        if (function == null) {
            throw new IllegalArgumentException();
        }
        this.function = function;
    }
}

