/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;

public class InteractionFeature
extends Feature {
    private List<? extends Feature> features = null;

    public InteractionFeature(PMMLEncoder encoder, TypeDefinitionField field, List<? extends Feature> features) {
        this(encoder, field.getName(), field.getDataType(), features);
    }

    public InteractionFeature(PMMLEncoder encoder, FieldName name, DataType dataType, List<? extends Feature> features) {
        super(encoder, name, dataType);
        this.setFeatures(features);
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        PMMLEncoder encoder = this.ensureEncoder();
        List<? extends Feature> features = this.getFeatures();
        DerivedField derivedField = encoder.getDerivedField(this.getName());
        if (derivedField == null) {
            Apply apply = PMMLUtil.createApply("*", new Expression[]{features.get(0).toContinuousFeature().ref(), features.get(1).toContinuousFeature().ref()});
            for (int i = 2; i < features.size(); ++i) {
                apply = PMMLUtil.createApply("*", new Expression[]{apply, features.get(i).toContinuousFeature().ref()});
            }
            derivedField = encoder.createDerivedField(this.getName(), OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
        }
        return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + Objects.hashCode(this.getFeatures());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof InteractionFeature) {
            InteractionFeature that = (InteractionFeature)object;
            return super.equals(object) && Objects.equals(this.getFeatures(), that.getFeatures());
        }
        return false;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("features", this.getFeatures());
    }

    public List<? extends Feature> getInputFeatures() {
        ArrayList<? extends Feature> result = new ArrayList<Feature>();
        List<? extends Feature> features = this.getFeatures();
        for (Feature feature : features) {
            if (feature instanceof InteractionFeature) {
                InteractionFeature interactionFeature = (InteractionFeature)feature;
                result.addAll(interactionFeature.getInputFeatures());
                continue;
            }
            result.add(feature);
        }
        return result;
    }

    public List<? extends Feature> getFeatures() {
        return this.features;
    }

    private void setFeatures(List<? extends Feature> features) {
        if (features == null || features.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.features = features;
    }
}

