/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.base.Objects;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.FieldRef;
import org.dmg.pmml.OpType;
import org.dmg.pmml.TypeDefinitionField;
import org.jpmml.converter.ContinuousFeature;
import org.jpmml.converter.Feature;
import org.jpmml.converter.HasDerivedName;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.PMMLUtil;

public class PowerFeature
extends Feature
implements HasDerivedName {
    private int power = 1;

    public PowerFeature(PMMLEncoder encoder, TypeDefinitionField field, int power) {
        this(encoder, field.getName(), field.getDataType(), power);
    }

    public PowerFeature(PMMLEncoder encoder, FieldName name, DataType dataType, int power) {
        super(encoder, name, dataType);
        this.setPower(power);
    }

    @Override
    public FieldName getDerivedName() {
        return FieldName.create((String)(this.getName().getValue() + "^" + this.getPower()));
    }

    @Override
    public ContinuousFeature toContinuousFeature() {
        FieldName derivedName;
        PMMLEncoder encoder = this.ensureEncoder();
        DerivedField derivedField = encoder.getDerivedField(derivedName = this.getDerivedName());
        if (derivedField == null) {
            Apply apply = PMMLUtil.createApply("pow", new Expression[]{new FieldRef(this.getName()), PMMLUtil.createConstant(this.getPower())});
            derivedField = encoder.createDerivedField(derivedName, OpType.CONTINUOUS, DataType.DOUBLE, (Expression)apply);
        }
        return new ContinuousFeature(encoder, (TypeDefinitionField)derivedField);
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.getPower();
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof PowerFeature) {
            PowerFeature that = (PowerFeature)object;
            return super.equals(object) && this.getPower() == that.getPower();
        }
        return false;
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("power", this.getPower());
    }

    public int getPower() {
        return this.power;
    }

    private void setPower(int power) {
        this.power = power;
    }
}

