/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.converter;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import java.util.List;
import org.dmg.pmml.Array;
import org.dmg.pmml.DataType;
import org.dmg.pmml.Predicate;
import org.dmg.pmml.SimplePredicate;
import org.dmg.pmml.SimpleSetPredicate;
import org.jpmml.converter.Feature;
import org.jpmml.converter.InternableSimplePredicate;
import org.jpmml.converter.InternableSimpleSetPredicate;
import org.jpmml.converter.ValueUtil;

public class PredicateManager {
    private Interner<Predicate> interner = Interners.newStrongInterner();

    public Predicate createSimpleSetPredicate(Feature feature, List<String> values) {
        if (values.size() == 1) {
            String value = values.get(0);
            return this.createSimplePredicate(feature, SimplePredicate.Operator.EQUAL, value);
        }
        SimpleSetPredicate predicate = new InternableSimpleSetPredicate().setField(feature.getName()).setBooleanOperator(SimpleSetPredicate.BooleanOperator.IS_IN).setArray(PredicateManager.createArray(feature.getDataType(), values));
        return this.intern((Predicate)predicate);
    }

    public Predicate createSimplePredicate(Feature feature, SimplePredicate.Operator operator, String value) {
        SimplePredicate predicate = new InternableSimplePredicate().setField(feature.getName()).setOperator(operator).setValue(value);
        return this.intern((Predicate)predicate);
    }

    public Predicate intern(Predicate predicate) {
        return (Predicate)this.interner.intern((Object)predicate);
    }

    private static Array createArray(DataType dataType, List<String> values) {
        switch (dataType) {
            case STRING: {
                return new Array(Array.Type.STRING, ValueUtil.formatArray(values));
            }
            case INTEGER: {
                return new Array(Array.Type.INT, ValueUtil.formatArray(values));
            }
            case DOUBLE: 
            case FLOAT: {
                return new Array(Array.Type.REAL, ValueUtil.formatArray(values));
            }
        }
        throw new IllegalArgumentException();
    }
}

