/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.opt.util;

import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.JobExecutor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public class ThreadService2 {
    private int min;
    private int max;
    private boolean simple;
    private int total = 0;
    private int idle = 0;
    private boolean terminated = false;
    private ArrayList jobList = new ArrayList();
    private ArrayList threadList = new ArrayList();
    private static final ThreadService2 shared = new ThreadService2(0, Integer.MAX_VALUE);
    private int defaultPriority;
    private ClassLoader defaultLoader;
    private int[] lock = new int[0];
    private static final int LEAVING_WAITING_TIME = 1000;
    private static final ClassLogger logger = new ClassLogger("com.sun.jmx.remote.opt.util", "ThreadService");

    public ThreadService2(int min, int max) {
        this(min, max, true);
    }

    public ThreadService2(int min, int max, boolean simple) {
        if (min < 0) {
            throw new IllegalArgumentException("Negative minimal thread number.");
        }
        if (max < min) {
            throw new IllegalArgumentException("Maximum number less than minimal number.");
        }
        this.min = min;
        this.max = max;
        this.simple = simple;
        this.defaultPriority = Thread.currentThread().getPriority();
        this.defaultLoader = this.getContextClassLoader();
        if (min > 0) {
            JobExecutor.handoff(new ThreadServiceJob());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handoff(Runnable job) {
        this.isTerminated();
        if (job == null) {
            throw new IllegalArgumentException("Null job.");
        }
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.jobList.add(job);
            if (this.jobList.size() <= this.idle) {
                this.lock.notify();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.total < this.min || this.total == 0) {
                ++this.total;
                JobExecutor.handoff(new ThreadServiceJob());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.total == this.max) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            Thread.yield();
            nArray = this.lock;
            synchronized (this.lock) {
                if (this.jobList.size() > this.idle && this.total < this.max) {
                    ++this.total;
                    JobExecutor.handoff(new ThreadServiceJob());
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.terminated) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.terminated = true;
            this.jobList.clear();
            this.lock.notifyAll();
            Thread ct = Thread.currentThread();
            while (this.threadList.size() > 0) {
                Thread rt = (Thread)this.threadList.remove(0);
                if (ct == rt) continue;
                rt.interrupt();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static ThreadService2 getShared() {
        return shared;
    }

    protected void finalize() {
        this.terminate();
    }

    private void isTerminated() throws IllegalStateException {
        if (this.terminated) {
            throw new IllegalStateException("The Thread Service has been terminated.");
        }
    }

    private ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private void setContextClassLoader(final Thread currentThread, final ClassLoader classloader) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                currentThread.setContextClassLoader(classloader);
                return null;
            }
        });
    }

    private class ThreadServiceJob
    implements Runnable {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            int[] nArray = ThreadService2.this.lock;
            synchronized (nArray) {
                ThreadService2.this.threadList.add(currentThread);
            }
            currentThread.setPriority(ThreadService2.this.defaultPriority);
            currentThread.interrupted();
            ThreadService2.this.setContextClassLoader(currentThread, ThreadService2.this.defaultLoader);
            Runnable job = null;
            while (!ThreadService2.this.terminated) {
                int[] nArray2 = ThreadService2.this.lock;
                synchronized (nArray2) {
                    block24: {
                        block26: {
                            long startTime;
                            long remainingTime;
                            block22: {
                                block25: {
                                    if (ThreadService2.this.jobList.size() != 0) break block25;
                                    if (ThreadService2.this.total > ThreadService2.this.min) {
                                        if (ThreadService2.this.idle == 0) {
                                            ThreadService2.this.idle++;
                                            remainingTime = 1000L;
                                            startTime = System.currentTimeMillis();
                                            break block22;
                                        } else {
                                            ThreadService2.this.total--;
                                            ThreadService2.this.threadList.remove(currentThread);
                                            break;
                                        }
                                    }
                                    ThreadService2.this.idle++;
                                    break block26;
                                }
                                job = (Runnable)ThreadService2.this.jobList.remove(0);
                                break block24;
                            }
                            while (ThreadService2.this.jobList.size() <= 0 && remainingTime > 0L) {
                                block23: {
                                    try {
                                        ThreadService2.this.lock.wait(remainingTime);
                                    }
                                    catch (InterruptedException e) {
                                        currentThread.interrupted();
                                        if (!ThreadService2.this.terminated) break block23;
                                        return;
                                    }
                                }
                                remainingTime = 1000L - (System.currentTimeMillis() - startTime);
                            }
                            ThreadService2.this.idle--;
                            if (ThreadService2.this.jobList.size() > 0) {
                                job = (Runnable)ThreadService2.this.jobList.remove(0);
                                break block24;
                            } else {
                                ThreadService2.this.total--;
                                ThreadService2.this.threadList.remove(currentThread);
                                break;
                            }
                        }
                        while (!ThreadService2.this.terminated && ThreadService2.this.jobList.size() <= 0) {
                            try {
                                ThreadService2.this.lock.wait();
                            }
                            catch (InterruptedException ire) {}
                        }
                        ThreadService2.this.idle--;
                        if (ThreadService2.this.terminated) {
                            break;
                        }
                        job = (Runnable)ThreadService2.this.jobList.remove(0);
                    }
                    if (ThreadService2.this.terminated) break;
                }
                try {
                    try {
                        job.run();
                        job = null;
                    }
                    catch (Exception e) {
                        if (logger.warningOn()) {
                            logger.warning("run", "Got an unexpected exception.", e);
                        }
                        job = null;
                    }
                }
                catch (Throwable throwable) {
                    job = null;
                    throw throwable;
                }
                currentThread.interrupted();
                if (ThreadService2.this.simple) continue;
                currentThread.setPriority(ThreadService2.this.defaultPriority);
                ThreadService2.this.setContextClassLoader(currentThread, ThreadService2.this.defaultLoader);
            }
            currentThread.interrupted();
        }
    }
}

