/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.ClientSynchroMessageConnection;
import com.sun.jmx.remote.generic.ClientSynchroMessageConnectionImpl;
import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.generic.SynchroCallback;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnector;
import javax.management.remote.generic.ClientIntermediary;
import javax.management.remote.generic.MessageConnection;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.message.CloseMessage;
import javax.management.remote.message.Message;
import javax.security.auth.Subject;

public class GenericConnector
implements JMXConnector {
    public static final String OBJECT_WRAPPING = "jmx.remote.object.wrapping";
    public static final String MESSAGE_CONNECTION = "jmx.remote.message.connection";
    private transient ClientSynchroMessageConnection connection;
    private transient ObjectWrapping objectWrapping;
    private transient Map env;
    private transient ClientIntermediary clientMBeanServer;
    private transient WeakHashMap rmbscMap = new WeakHashMap();
    private transient String connectionId;
    private transient RequestHandler requestHandler;
    private final transient NotificationBroadcasterSupport connectionBroadcaster;
    private static final int CREATED = 1;
    private static final int CONNECTED = 2;
    private static final int CLOSED = 3;
    private transient int state = 1;
    private transient int[] lock = new int[0];
    private transient long clientNotifID = 0L;
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.generic", "GenericConnector");

    public GenericConnector() {
        this(null);
    }

    public GenericConnector(Map env) {
        if (env == null) {
            this.env = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(env);
            this.env = Collections.unmodifiableMap(env);
        }
        this.connectionBroadcaster = new NotificationBroadcasterSupport();
    }

    @Override
    public void connect() throws IOException {
        this.connect((Map)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(Map env) throws IOException {
        boolean tracing = logger.traceOn();
        String idstr = tracing ? "[" + this.toString() + "]" : null;
        int[] nArray = this.lock;
        synchronized (this.lock) {
            MessageConnection conn;
            switch (this.state) {
                case 1: {
                    break;
                }
                case 2: {
                    if (tracing) {
                        logger.trace("connect", idstr + " already connected.");
                    }
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                case 3: {
                    if (tracing) {
                        logger.trace("connect", idstr + " already closed.");
                    }
                    throw new IOException("Connector already closed.");
                }
                default: {
                    if (tracing) {
                        logger.trace("connect", idstr + " unknown state: " + this.state);
                    }
                    throw new IOException("Invalid state (" + this.state + ")");
                }
            }
            HashMap tmpEnv = new HashMap(this.env == null ? Collections.EMPTY_MAP : this.env);
            if (env != null) {
                EnvHelp.checkAttributes(env);
                tmpEnv.putAll(env);
            }
            if ((conn = (MessageConnection)tmpEnv.get(MESSAGE_CONNECTION)) == null) {
                this.connection = DefaultConfig.getClientSynchroMessageConnection(tmpEnv);
                if (this.connection == null) {
                    if (tracing) {
                        logger.trace("connect", idstr + " No MessageConnection");
                    }
                    throw new IllegalArgumentException("No MessageConnection");
                }
                if (tracing) {
                    logger.trace("connect", "The connection uses a user specific Synchronous message connection.");
                }
            } else {
                this.requestHandler = new RequestHandler();
                this.connection = new ClientSynchroMessageConnectionImpl(conn, this.requestHandler, tmpEnv);
                if (tracing) {
                    logger.trace("connect", "The connection uses a user specific Asynchronous message connection.");
                }
            }
            this.connection.connect(tmpEnv);
            this.connectionId = this.connection.getConnectionId();
            this.objectWrapping = (ObjectWrapping)tmpEnv.get(OBJECT_WRAPPING);
            if (this.objectWrapping == null) {
                this.objectWrapping = new ObjectWrappingImpl();
            }
            this.clientMBeanServer = new ClientIntermediary(this.connection, this.objectWrapping, this, tmpEnv);
            this.env = tmpEnv;
            this.state = 2;
            if (tracing) {
                logger.trace("connect", idstr + " " + this.connectionId + " Connected.");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifID++, null, null));
            return;
        }
    }

    @Override
    public String getConnectionId() throws IOException {
        this.checkState();
        return this.connection.getConnectionId();
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection() throws IOException {
        return this.getMBeanServerConnection(null);
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(Subject delegationSubject) throws IOException {
        this.checkState();
        if (this.rmbscMap.containsKey(delegationSubject)) {
            return (MBeanServerConnection)this.rmbscMap.get(delegationSubject);
        }
        RemoteMBeanServerConnection rmbsc = new RemoteMBeanServerConnection(this.clientMBeanServer, delegationSubject);
        this.rmbscMap.put(delegationSubject, rmbsc);
        return rmbsc;
    }

    @Override
    public void close() throws IOException {
        this.close(false, "The connection is closed by a user.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean local, String msg) throws IOException {
        boolean tracing = logger.traceOn();
        boolean debug = logger.debugOn();
        String idstr = tracing ? "[" + this.toString() + "]" : null;
        int[] nArray = this.lock;
        synchronized (this.lock) {
            Exception closeException;
            boolean createdState;
            block25: {
                if (this.state == 3) {
                    if (tracing) {
                        logger.trace("close", idstr + " already closed.");
                    }
                    // ** MonitorExit[var8_6] (shouldn't be in output)
                    return;
                }
                createdState = this.state == 1;
                this.state = 3;
                closeException = null;
                if (tracing) {
                    logger.trace("close", idstr + " closing.");
                }
                if (!createdState) {
                    block24: {
                        if (!local) {
                            try {
                                ClientSynchroMessageConnection clientSynchroMessageConnection = this.connection;
                                synchronized (clientSynchroMessageConnection) {
                                    this.connection.sendOneWay(new CloseMessage(msg));
                                    Thread.sleep(100L);
                                }
                            }
                            catch (InterruptedException ire) {
                            }
                            catch (Exception e1) {
                                closeException = e1;
                                if (tracing) {
                                    logger.trace("close", idstr + " failed to send close message: " + e1);
                                }
                                if (!debug) break block24;
                                logger.debug("close", e1);
                            }
                        }
                    }
                    try {
                        this.connection.close();
                    }
                    catch (Exception e1) {
                        closeException = e1;
                        if (tracing) {
                            logger.trace("close", idstr + " failed to close MessageConnection: " + e1);
                        }
                        if (!debug) break block25;
                        logger.debug("close", e1);
                    }
                }
            }
            if (this.clientMBeanServer != null) {
                this.clientMBeanServer.terminate();
            }
            this.rmbscMap.clear();
            // ** MonitorExit[var8_6] (shouldn't be in output)
            if (!createdState) {
                this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.closed", this, this.connectionId, this.clientNotifID++, "The client has been closed.", null));
            }
            if (closeException != null) {
                if (closeException instanceof RuntimeException) {
                    throw (RuntimeException)closeException;
                }
                if (closeException instanceof IOException) {
                    throw (IOException)closeException;
                }
                IOException x = new IOException("Failed to close: " + closeException);
                throw (IOException)EnvHelp.initCause(x, closeException);
            }
            if (tracing) {
                logger.trace("close", idstr + " closed.");
            }
            return;
        }
    }

    @Override
    public void addConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(listener);
    }

    @Override
    public void removeConnectionNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.connectionBroadcaster.removeNotificationListener(listener, filter, handback);
    }

    protected void sendNotification(final Notification n) {
        Runnable job = new Runnable(){

            @Override
            public void run() {
                try {
                    GenericConnector.this.connectionBroadcaster.sendNotification(n);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ThreadService.getShared().handoff(job);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientSynchroMessageConnection reconnect() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state != 2) {
                throw new IOException("The connector is not at the connection state.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.failed", this, this.connectionId, this.clientNotifID++, "The client has got connection exception.", null));
            this.connection.connect(this.env);
            this.connectionId = this.connection.getConnectionId();
            this.sendNotification(new JMXConnectionNotification("jmx.remote.connection.opened", this, this.connectionId, this.clientNotifID++, "The client has succesfully reconnected to the server.", null));
            return this.connection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkState() throws IOException {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 1) {
                throw new IOException("The client has not been connected.");
            }
            if (this.state == 3) {
                throw new IOException("The client has been closed.");
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private static class ResponseMsgWrapper {
        public boolean got = false;
        public Message msg = null;

        public void setMsg(Message msg) {
            this.got = true;
            this.msg = msg;
        }
    }

    private class RequestHandler
    implements SynchroCallback {
        private RequestHandler() {
        }

        @Override
        public Message execute(Message msg) {
            if (msg instanceof CloseMessage) {
                if (logger.traceOn()) {
                    logger.trace("RequestHandler-execute", "got Message REMOTE_TERMINATION");
                }
                try {
                    ClientIntermediary.GenericClientCommunicatorAdmin admin = GenericConnector.this.clientMBeanServer.getCommunicatorAdmin();
                    admin.gotIOException(new IOException(""));
                    return null;
                }
                catch (IOException ioe) {
                    try {
                        GenericConnector.this.close(true, null);
                    }
                    catch (IOException ie) {}
                }
            } else {
                String errstr = (msg == null ? "null" : msg.getClass().getName()) + ": Bad message type.";
                logger.warning("RequestHandler-execute", errstr);
                try {
                    logger.warning("RequestHandler-execute", "Closing connector");
                    GenericConnector.this.close(false, null);
                }
                catch (IOException ie) {
                    logger.info("RequestHandler-execute", ie);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void connectionException(Exception e) {
            int[] nArray = GenericConnector.this.lock;
            synchronized (nArray) {
                if (GenericConnector.this.state != 2) {
                    return;
                }
            }
            logger.warning("RequestHandler-connectionException", e);
            if (e instanceof IOException) {
                try {
                    ClientIntermediary.GenericClientCommunicatorAdmin admin = GenericConnector.this.clientMBeanServer.getCommunicatorAdmin();
                    admin.gotIOException((IOException)e);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            nArray = GenericConnector.this.lock;
            synchronized (nArray) {
                if (GenericConnector.this.state == 2) {
                    logger.warning("RequestHandler-connectionException", "Got connection exception: " + e.toString());
                    logger.debug("RequestHandler-connectionException", "Got connection exception: " + e.toString(), e);
                    try {
                        GenericConnector.this.close(true, null);
                    }
                    catch (IOException ie) {
                        logger.info("RequestHandler-execute", ie);
                    }
                }
            }
        }
    }

    private static class RemoteMBeanServerConnection
    implements MBeanServerConnection {
        private ClientIntermediary ci;
        private Subject ds;

        public RemoteMBeanServerConnection(ClientIntermediary ci) {
            this(ci, null);
        }

        public RemoteMBeanServerConnection(ClientIntermediary ci, Subject ds) {
            this.ci = ci;
            this.ds = ds;
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            return this.ci.createMBean(className, name, this.ds);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            return this.ci.createMBean(className, name, loaderName, this.ds);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, IOException {
            return this.ci.createMBean(className, name, params, signature, this.ds);
        }

        @Override
        public ObjectInstance createMBean(String className, ObjectName name, ObjectName loaderName, Object[] params, String[] signature) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException, IOException {
            return this.ci.createMBean(className, name, loaderName, params, signature, this.ds);
        }

        @Override
        public void unregisterMBean(ObjectName name) throws InstanceNotFoundException, MBeanRegistrationException, IOException {
            this.ci.unregisterMBean(name, this.ds);
        }

        @Override
        public ObjectInstance getObjectInstance(ObjectName name) throws InstanceNotFoundException, IOException {
            return this.ci.getObjectInstance(name, this.ds);
        }

        public Set queryMBeans(ObjectName name, QueryExp query) throws IOException {
            return this.ci.queryMBeans(name, query, this.ds);
        }

        public Set queryNames(ObjectName name, QueryExp query) throws IOException {
            return this.ci.queryNames(name, query, this.ds);
        }

        @Override
        public boolean isRegistered(ObjectName name) throws IOException {
            return this.ci.isRegistered(name, this.ds);
        }

        @Override
        public Integer getMBeanCount() throws IOException {
            return this.ci.getMBeanCount(this.ds);
        }

        @Override
        public Object getAttribute(ObjectName name, String attribute) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException, IOException {
            return this.ci.getAttribute(name, attribute, this.ds);
        }

        @Override
        public AttributeList getAttributes(ObjectName name, String[] attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            return this.ci.getAttributes(name, attributes, this.ds);
        }

        @Override
        public void setAttribute(ObjectName name, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException, IOException {
            this.ci.setAttribute(name, attribute, this.ds);
        }

        @Override
        public AttributeList setAttributes(ObjectName name, AttributeList attributes) throws InstanceNotFoundException, ReflectionException, IOException {
            return this.ci.setAttributes(name, attributes, this.ds);
        }

        @Override
        public Object invoke(ObjectName name, String operationName, Object[] params, String[] signature) throws InstanceNotFoundException, MBeanException, ReflectionException, IOException {
            return this.ci.invoke(name, operationName, params, signature, this.ds);
        }

        @Override
        public String getDefaultDomain() throws IOException {
            return this.ci.getDefaultDomain(this.ds);
        }

        @Override
        public String[] getDomains() throws IOException {
            return this.ci.getDomains(this.ds);
        }

        @Override
        public void addNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            this.ci.addNotificationListener(name, listener, filter, handback, this.ds);
        }

        @Override
        public void addNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, IOException {
            this.ci.addNotificationListener(name, listener, filter, handback, this.ds);
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(name, listener, this.ds);
        }

        @Override
        public void removeNotificationListener(ObjectName name, ObjectName listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(name, listener, filter, handback, this.ds);
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(name, listener, this.ds);
        }

        @Override
        public void removeNotificationListener(ObjectName name, NotificationListener listener, NotificationFilter filter, Object handback) throws InstanceNotFoundException, ListenerNotFoundException, IOException {
            this.ci.removeNotificationListener(name, listener, filter, handback, this.ds);
        }

        @Override
        public MBeanInfo getMBeanInfo(ObjectName name) throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
            return this.ci.getMBeanInfo(name, this.ds);
        }

        @Override
        public boolean isInstanceOf(ObjectName name, String className) throws InstanceNotFoundException, IOException {
            return this.ci.isInstanceOf(name, className, this.ds);
        }
    }
}

