/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.generic;

import com.sun.jmx.remote.generic.DefaultConfig;
import com.sun.jmx.remote.generic.ObjectWrappingImpl;
import com.sun.jmx.remote.generic.ServerSynchroMessageConnection;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServer;
import com.sun.jmx.remote.generic.SynchroMessageConnectionServerImpl;
import com.sun.jmx.remote.opt.internal.ArrayNotificationBuffer;
import com.sun.jmx.remote.opt.internal.NotificationBuffer;
import com.sun.jmx.remote.opt.security.MBeanServerFileAccessController;
import com.sun.jmx.remote.opt.util.ClassLogger;
import com.sun.jmx.remote.opt.util.EnvHelp;
import com.sun.jmx.remote.opt.util.ThreadService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.generic.MessageConnectionServer;
import javax.management.remote.generic.ObjectWrapping;
import javax.management.remote.generic.ServerIntermediary;
import javax.security.auth.Subject;

public class GenericConnectorServer
extends JMXConnectorServer {
    public static final String OBJECT_WRAPPING = "jmx.remote.object.wrapping";
    public static final String MESSAGE_CONNECTION_SERVER = "jmx.remote.message.connection.server";
    private static final ClassLogger logger = new ClassLogger("javax.management.remote.generic", "GenericConnectorServer");
    private Receiver receiver;
    private SynchroMessageConnectionServer sMsgServer;
    private ObjectWrapping objectWrapping;
    private Map env;
    private ClassLoader defaultClassLoader = null;
    private ArrayList clientList = new ArrayList();
    private static final int DEFAULT_NOTIF_BUFFER_SIZE = 1000;
    private static final int CREATED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private int state = 0;
    private int[] lock = new int[0];
    private static long clientIDCount = 0L;
    private static final int[] clientIDCountLock = new int[0];
    private NotificationBuffer notifBuffer;
    private final long connectingTimeout;
    private static Timer cancelConnecting = new Timer(true);

    public GenericConnectorServer(Map env, MBeanServer mbs) {
        super(mbs);
        if (env == null) {
            this.env = Collections.EMPTY_MAP;
        } else {
            EnvHelp.checkAttributes(env);
            this.env = Collections.unmodifiableMap(env);
        }
        this.connectingTimeout = DefaultConfig.getConnectingTimeout(this.env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clientClosing(ServerIntermediary inter, String connectionId, String msg, Object userData) {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            this.clientList.remove(inter);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            super.connectionClosed(connectionId, msg, userData);
            return;
        }
    }

    @Override
    public JMXServiceURL getAddress() {
        if (!this.isActive()) {
            return null;
        }
        return this.sMsgServer.getAddress();
    }

    public Map getAttributes() {
        Map map = EnvHelp.filterAttributes(this.env);
        return Collections.unmodifiableMap(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IOException {
        boolean tracing = logger.traceOn();
        int[] nArray = this.lock;
        synchronized (this.lock) {
            MessageConnectionServer messageServer;
            String accessFile;
            MBeanServer mbs;
            if (this.state == 1) {
                if (tracing) {
                    logger.trace("start", "already started");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.state == 2) {
                if (tracing) {
                    logger.trace("start", "already stopped");
                }
                throw new IOException("The server has been stopped.");
            }
            if (tracing) {
                logger.trace("start", "starting...");
            }
            if (tracing) {
                logger.trace("start", "setting MBeanServer...");
            }
            if ((mbs = this.getMBeanServer()) == null) {
                throw new IllegalStateException("This connector server is not attached to an MBean server");
            }
            if (this.env != null && (accessFile = (String)this.env.get("jmx.remote.x.access.file")) != null) {
                MBeanServerFileAccessController mbsf = null;
                try {
                    mbsf = new MBeanServerFileAccessController(accessFile);
                }
                catch (IOException e) {
                    throw (IllegalArgumentException)EnvHelp.initCause(new IllegalArgumentException(e.getMessage()), e);
                }
                this.setMBeanServerForwarder(mbsf);
                mbs = this.getMBeanServer();
            }
            if (tracing) {
                logger.trace("start", "setting default ClassLoader...");
            }
            try {
                this.defaultClassLoader = EnvHelp.resolveServerClassLoader(this.env, mbs);
            }
            catch (InstanceNotFoundException infc) {
                if (tracing) {
                    logger.debug("start", "ClassLoader not found: " + infc);
                }
                IllegalArgumentException x = new IllegalArgumentException("ClassLoader not found: " + infc);
                throw (IllegalArgumentException)EnvHelp.initCause(x, infc);
            }
            if (tracing) {
                logger.trace("start", "setting ObjectWrapping...");
            }
            this.objectWrapping = (ObjectWrapping)this.env.get(OBJECT_WRAPPING);
            if (this.objectWrapping == null) {
                this.objectWrapping = new ObjectWrappingImpl();
            }
            if ((messageServer = (MessageConnectionServer)this.env.get(MESSAGE_CONNECTION_SERVER)) == null) {
                this.sMsgServer = DefaultConfig.getSynchroMessageConnectionServer(this.env);
                if (this.sMsgServer == null) {
                    String msg = "No message connection server";
                    throw new IllegalArgumentException("No message connection server");
                }
            } else {
                this.sMsgServer = new SynchroMessageConnectionServerImpl(messageServer, this.env);
            }
            this.sMsgServer.start(this.env);
            this.state = 1;
            if (tracing) {
                logger.trace("start", "Connector Server Address = " + this.sMsgServer.getAddress());
                logger.trace("start", "started.");
            }
            this.receiver = new Receiver();
            this.receiver.start();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        boolean tracing = logger.traceOn();
        int[] nArray = this.lock;
        synchronized (this.lock) {
            if (this.state == 2) {
                if (tracing) {
                    logger.trace("stop", "already stopped.");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.state == 0 && tracing) {
                logger.trace("stop", "not started yet.");
            }
            this.state = 2;
            boolean debug = logger.debugOn();
            if (tracing) {
                logger.trace("stop", "stoping.");
            }
            Object re = null;
            if (tracing) {
                logger.trace("stop", "stop MessageConnectionServer...");
            }
            if (this.sMsgServer != null) {
                this.sMsgServer.stop();
            }
            if (tracing) {
                logger.trace("stop", "stop clients...");
            }
            if (tracing) {
                logger.trace("stop", this.clientList.size() + "client(s) found...");
            }
            while (this.clientList.size() > 0) {
                try {
                    ServerIntermediary inter = (ServerIntermediary)this.clientList.remove(0);
                    inter.terminate();
                }
                catch (Exception e) {
                    logger.warning("stop", "Failed to stop client: " + e);
                    if (!debug) continue;
                    logger.debug("stop", e);
                }
            }
            if (this.notifBuffer != null) {
                this.notifBuffer.dispose();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            cancelConnecting.cancel();
            if (tracing) {
                logger.trace("stop", "stopped.");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isActive() {
        int[] nArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.state == 1;
        }
    }

    void failedConnectionNotif(String connectionId, String message, Object userData) {
        super.connectionFailed(connectionId, message, userData);
    }

    synchronized NotificationBuffer getNotifBuffer() {
        if (this.notifBuffer == null) {
            this.notifBuffer = ArrayNotificationBuffer.getNotificationBuffer(this.getMBeanServer(), this.env);
        }
        return this.notifBuffer;
    }

    private class ConnectingStopper
    extends TimerTask {
        private final ClientCreation cc;

        public ConnectingStopper(ClientCreation cc) {
            this.cc = cc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: {
                ClientCreation clientCreation = this.cc;
                synchronized (clientCreation) {
                    if (this.cc.done) {
                        return;
                    }
                    this.cc.done = true;
                }
                if (logger.traceOn()) {
                    logger.trace("ConnectingStopper.run", "Connecting timeout for: " + this.cc.connection);
                }
                try {
                    this.cc.connection.close();
                }
                catch (Exception e) {
                    if (!logger.debugOn()) break block7;
                    logger.debug("ConnectingStoper.run", e);
                }
            }
        }
    }

    private class ClientCreation
    implements Runnable {
        ServerSynchroMessageConnection connection;
        private boolean done = false;
        private ConnectingStopper stopper;

        public ClientCreation(ServerSynchroMessageConnection connection) {
            this.connection = connection;
        }

        public void setStopper(ConnectingStopper stopper) {
            this.stopper = stopper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean failed;
            Subject subject;
            boolean tracing;
            block26: {
                tracing = logger.traceOn();
                subject = null;
                failed = false;
                try {
                    this.connection.connect(GenericConnectorServer.this.env);
                    if (tracing) {
                        logger.trace("ClientCreation.run", "opening connection.");
                    }
                    subject = this.connection.getSubject();
                }
                catch (Throwable e) {
                    failed = true;
                    logger.warning("ClientCreation.run", "Failed to open connection: " + e, e);
                    if (tracing) {
                        logger.debug("ClientCreation.run", e);
                    }
                    try {
                        if (tracing) {
                            logger.debug("ClientCreation.run", "cleaning up...");
                        }
                        this.connection.close();
                    }
                    catch (Exception ee) {
                        if (logger.debugOn()) {
                            logger.debug("ClientCreation.run", "Failed to cleanup: " + ee);
                        }
                        if (!logger.debugOn()) break block26;
                        logger.debug("ClientCreation.run", ee);
                    }
                }
            }
            ClientCreation e = this;
            synchronized (e) {
                if (this.done) {
                    failed = true;
                } else {
                    this.done = true;
                    if (this.stopper != null) {
                        this.stopper.cancel();
                    }
                }
            }
            if (failed) {
                return;
            }
            if (tracing) {
                logger.trace("ClientCreation.run", "connection opened.");
            }
            ServerIntermediary inter = new ServerIntermediary(GenericConnectorServer.this.getMBeanServer(), GenericConnectorServer.this, this.connection, GenericConnectorServer.this.objectWrapping, subject, GenericConnectorServer.this.defaultClassLoader, GenericConnectorServer.this.env);
            int[] ee = GenericConnectorServer.this.lock;
            synchronized (ee) {
                if (GenericConnectorServer.this.state != 1) {
                    block27: {
                        try {
                            if (logger.debugOn()) {
                                logger.debug("ClientCreation.run", "connector already stopped.");
                            }
                            if (tracing) {
                                logger.trace("ClientCreation.run", "cleaning up...");
                            }
                            inter.terminate();
                        }
                        catch (Exception e2) {
                            if (logger.debugOn()) {
                                logger.debug("ClientCreation.run", "Failed to cleanup: " + e2);
                            }
                            if (!logger.debugOn()) break block27;
                            logger.debug("ClientCreation.run", e2);
                        }
                    }
                    return;
                }
                if (tracing) {
                    logger.trace("ClientCreation.run", "adding connection to client list.");
                }
                GenericConnectorServer.this.clientList.add(inter);
            }
            String cid = this.connection.getConnectionId();
            GenericConnectorServer.this.connectionOpened(cid, "New client connection " + cid + " has been established", null);
            inter.start();
        }
    }

    private class Receiver
    extends Thread {
        private Receiver() {
        }

        @Override
        public void run() {
            if (logger.debugOn()) {
                logger.debug("Receiver.run", "starting receiver.");
            }
            while (GenericConnectorServer.this.isActive()) {
                boolean tracing = logger.traceOn();
                ServerSynchroMessageConnection connection = null;
                boolean debug = logger.debugOn();
                if (tracing) {
                    logger.trace("Receiver.run", "waiting for connection.");
                }
                try {
                    connection = GenericConnectorServer.this.sMsgServer.accept();
                }
                catch (IOException ioe) {
                    if (GenericConnectorServer.this.isActive()) {
                        logger.error("Receiver.run", "Unexpected IOException: " + ioe);
                        if (debug) {
                            logger.debug("Receiver.run", ioe);
                        }
                        try {
                            logger.error("Receiver.run", "stopping server");
                            GenericConnectorServer.this.stop();
                        }
                        catch (IOException ie) {
                            logger.warning("Receiver.run", "Failed to stop server: " + ie);
                            if (!debug) break;
                            logger.debug("Receiver.run", ie);
                        }
                        break;
                    }
                    if (!tracing) break;
                    logger.trace("Receiver.run", "interrupted: " + ioe);
                    break;
                }
                if (!GenericConnectorServer.this.isActive()) {
                    return;
                }
                if (tracing) {
                    logger.trace("Receiver.run", "received connection request.");
                }
                ClientCreation cc = new ClientCreation(connection);
                if (GenericConnectorServer.this.connectingTimeout <= 0L) {
                    ThreadService.getShared().handoff(cc);
                    continue;
                }
                ConnectingStopper stopper = new ConnectingStopper(cc);
                cc.setStopper(stopper);
                ThreadService.getShared().handoff(cc);
                cancelConnecting.schedule((TimerTask)stopper, GenericConnectorServer.this.connectingTimeout);
            }
            if (logger.debugOn()) {
                logger.debug("Receiver.run", "receiver terminated");
            }
        }
    }
}

