/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.GeneralDataCoding;
import org.jsmpp.bean.MessageType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.SMSCDeliveryReceipt;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.session.Session;
import org.jsmpp.session.SubmitSmResult;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSubmitUSSDExample {
    private static final Logger log = LoggerFactory.getLogger(SimpleSubmitUSSDExample.class);
    private static final MessageIDGenerator MESSAGE_ID_GENERATOR = new RandomMessageIDGenerator();

    public static void main(String[] args) {
        final CountDownLatch latch = new CountDownLatch(1);
        SMPPSession session = new SMPPSession();
        session.setMessageReceiverListener(new MessageReceiverListener(){

            public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
                if (MessageType.SMSC_DEL_RECEIPT.containedIn(deliverSm.getEsmClass())) {
                    log.info("Received unexpected deliver receipt from {}", (Object)deliverSm.getSourceAddr());
                } else {
                    String serviceType = deliverSm.getServiceType();
                    log.info("Receiving {} USSD message: {}", (Object)serviceType, (Object)new String(deliverSm.getShortMessage(), StandardCharsets.US_ASCII));
                    for (OptionalParameter optionalParameter : deliverSm.getOptionalParameters()) {
                        String tagHex = String.format("%04x", optionalParameter.tag);
                        if (optionalParameter instanceof OptionalParameter.Null) {
                            log.info("Optional parameter {}: null", (Object)tagHex);
                            continue;
                        }
                        if (optionalParameter instanceof OptionalParameter.Byte) {
                            OptionalParameter.Byte optionalByte = (OptionalParameter.Byte)optionalParameter;
                            log.info("Optional parameter {}: {}", (Object)tagHex, (Object)(optionalByte.getValue() & 0xFF));
                            continue;
                        }
                        if (optionalParameter instanceof OptionalParameter.Short) {
                            OptionalParameter.Short optionalShort = (OptionalParameter.Short)optionalParameter;
                            log.info("Optional parameter {}: {}", (Object)tagHex, (Object)(optionalShort.getValue() & 0xFFFF));
                            continue;
                        }
                        if (optionalParameter instanceof OptionalParameter.Int) {
                            OptionalParameter.Int optionalInt = (OptionalParameter.Int)optionalParameter;
                            log.info("Optional parameter {}: {}", (Object)tagHex, (Object)optionalInt.getValue());
                            continue;
                        }
                        if (optionalParameter instanceof OptionalParameter.COctetString) {
                            OptionalParameter.COctetString cOctetString = (OptionalParameter.COctetString)optionalParameter;
                            log.info("Optional parameter {}: {}", (Object)tagHex, (Object)cOctetString.getValueAsString());
                            continue;
                        }
                        if (!(optionalParameter instanceof OptionalParameter.OctetString)) continue;
                        OptionalParameter.OctetString octetString = (OptionalParameter.OctetString)optionalParameter;
                        log.info("Optional parameter {}: {}", (Object)tagHex, (Object)octetString.getValueAsString());
                    }
                    latch.countDown();
                }
            }

            public void onAcceptAlertNotification(AlertNotification alertNotification) {
                log.info("Received alert_notification");
            }

            public DataSmResult onAcceptDataSm(DataSm dataSm, Session source) throws ProcessRequestException {
                log.info("Received data_sm");
                return new DataSmResult(MESSAGE_ID_GENERATOR.newMessageId(), new OptionalParameter[0]);
            }
        });
        try {
            log.info("Connecting");
            String systemId = session.connectAndBind("localhost", 2775, new BindParameter(BindType.BIND_TRX, "SP", "password", "0", TypeOfNumber.UNKNOWN, NumberingPlanIndicator.UNKNOWN, null));
            log.info("Connected with USSD Message Centre with system id {}", (Object)systemId);
            String sourceAddress = "*111";
            String destinationAddress = "628176504657";
            try {
                String message = "1. First Menu Item\n2. Second Menu Item\n0. Help\n* Exit";
                SubmitSmResult beginRequestResult = session.submitShortMessage("BR", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, sourceAddress, TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, destinationAddress, new ESMClass(), (byte)0, (byte)0, null, null, new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT), (byte)0, (DataCoding)new GeneralDataCoding(Alphabet.ALPHA_8_BIT), (byte)0, message.getBytes(StandardCharsets.US_ASCII), new OptionalParameter[0]);
                String beginRequestMessageId = beginRequestResult.getMessageId();
                log.info("USSD BR message submitted, message_id is {}", (Object)beginRequestMessageId);
                latch.await(60000L, TimeUnit.MILLISECONDS);
                SubmitSmResult endReleaseResult = session.submitShortMessage("EF", TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, sourceAddress, TypeOfNumber.INTERNATIONAL, NumberingPlanIndicator.ISDN, destinationAddress, new ESMClass(), (byte)0, (byte)0, null, null, new RegisteredDelivery(SMSCDeliveryReceipt.DEFAULT), (byte)0, (DataCoding)new GeneralDataCoding(Alphabet.ALPHA_8_BIT), (byte)0, "The weather is nice today.".getBytes(StandardCharsets.US_ASCII), new OptionalParameter[0]);
                String endReleaseMessageId = endReleaseResult.getMessageId();
                log.info("USSD EF message submitted, message_id is {}", (Object)endReleaseMessageId);
            }
            catch (InterruptedException e) {
                log.error("Interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (PDUException e) {
                log.error("Invalid PDU parameter", (Throwable)e);
            }
            catch (ResponseTimeoutException e) {
                log.error("Response timeout", (Throwable)e);
            }
            catch (InvalidResponseException e) {
                log.error("Receive invalid response", (Throwable)e);
            }
            catch (NegativeResponseException e) {
                log.error("Receive negative response, e");
            }
            catch (IOException e) {
                log.error("IO error occurred", (Throwable)e);
            }
            session.unbindAndClose();
        }
        catch (IOException e) {
            log.error("Failed connect and bind to host", (Throwable)e);
        }
    }
}

