/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.examples.receipts;

import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.DeliveryReceiptStrip;
import org.jsmpp.bean.MessageType;
import org.jsmpp.util.DeliveryReceiptState;
import org.jsmpp.util.InvalidDeliveryReceiptException;

public class ExampleDeliveryReceiptStripper
implements DeliveryReceiptStrip<DeliveryReceipt> {
    private static final Pattern PATTERN = Pattern.compile("^id:([0-9]*) sub:([0-9]{3}) dlvrd:([0-9]{3}) submit date:([0-9]{10}) done date:([0-9]{10}) stat:([a-zA-Z]*)$");
    private static final ExampleDeliveryReceiptStripper instance = new ExampleDeliveryReceiptStripper();

    public static ExampleDeliveryReceiptStripper getInstance() {
        return instance;
    }

    public DeliveryReceipt strip(DeliverSm deliverSm) throws InvalidDeliveryReceiptException {
        if (MessageType.SMSC_DEL_RECEIPT.containedIn(deliverSm.getEsmClass()) || MessageType.SME_DEL_ACK.containedIn(deliverSm.getEsmClass())) {
            return this.deliveryReceipt(deliverSm.getShortMessage());
        }
        throw new InvalidDeliveryReceiptException("deliver_sm is not a delivery receipt since esm_class value = " + deliverSm.getEsmClass());
    }

    private DeliveryReceipt deliveryReceipt(byte[] shortMessage) {
        DeliveryReceipt deliveryReceipt = new DeliveryReceipt();
        Matcher matcher = PATTERN.matcher(new String(shortMessage));
        if (matcher.find()) {
            String id = matcher.group(1);
            String submitted = matcher.group(2);
            String delivered = matcher.group(3);
            String submitDate = matcher.group(4);
            String doneDate = matcher.group(5);
            String status = matcher.group(6);
            deliveryReceipt.setId(id);
            deliveryReceipt.setSubmitted(Integer.parseInt(submitted));
            deliveryReceipt.setDelivered(Integer.parseInt(delivered));
            deliveryReceipt.setSubmitDate(ExampleDeliveryReceiptStripper.string2Date(submitDate));
            deliveryReceipt.setDoneDate(ExampleDeliveryReceiptStripper.string2Date(doneDate));
            deliveryReceipt.setError("000");
            deliveryReceipt.setText("");
            if ("Successful".equals(status)) {
                deliveryReceipt.setFinalStatus(DeliveryReceiptState.DELIVRD);
            } else {
                deliveryReceipt.setFinalStatus(DeliveryReceiptState.valueOf((String)status));
            }
        }
        return deliveryReceipt;
    }

    private static Date string2Date(String date) {
        int year = Integer.parseInt(date.substring(0, 2));
        int month = Integer.parseInt(date.substring(2, 4) + 1);
        int day = Integer.parseInt(date.substring(4, 6));
        int hour = Integer.parseInt(date.substring(6, 8));
        int minute = Integer.parseInt(date.substring(8, 10));
        Calendar cal = Calendar.getInstance();
        cal.set(ExampleDeliveryReceiptStripper.convertTwoDigitYear(year), month - 1, day, hour, minute, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static int convertTwoDigitYear(int year) {
        if (year >= 0 && year <= 37) {
            return 2000 + year;
        }
        if (year >= 38 && year <= 99) {
            return 1900 + year;
        }
        return year;
    }
}

