/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.listeners;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.launcher.TestExecutionListener;
import org.junit.gen5.launcher.TestIdentifier;
import org.junit.gen5.launcher.TestPlan;

@API(value=API.Usage.Experimental)
public class LoggingListener
implements TestExecutionListener {
    private final BiConsumer<Throwable, Supplier<String>> logger;

    public static LoggingListener forJavaUtilLogging() {
        return LoggingListener.forJavaUtilLogging(Level.FINE);
    }

    public static LoggingListener forJavaUtilLogging(Level logLevel) {
        Logger logger = Logger.getLogger(LoggingListener.class.getName());
        return new LoggingListener((t, messageSupplier) -> logger.log(logLevel, (Throwable)t, (Supplier<String>)messageSupplier));
    }

    public LoggingListener(BiConsumer<Throwable, Supplier<String>> logger) {
        this.logger = logger;
    }

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.log("TestPlan Execution Started: %s", testPlan);
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.log("TestPlan Execution Finished: %s", testPlan);
    }

    @Override
    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        this.log("Dynamic Test Registered: %s - %s", testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    @Override
    public void executionStarted(TestIdentifier testIdentifier) {
        this.log("Execution Started: %s - %s", testIdentifier.getDisplayName(), testIdentifier.getUniqueId());
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        this.log("Execution Skipped: %s - %s - %s", testIdentifier.getDisplayName(), testIdentifier.getUniqueId(), reason);
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        this.logWithThrowable("Execution Finished: %s - %s - %s", testExecutionResult.getThrowable().orElse(null), testIdentifier.getDisplayName(), testIdentifier.getUniqueId(), testExecutionResult);
    }

    private void log(String message, Object ... args) {
        this.logWithThrowable(message, null, args);
    }

    private void logWithThrowable(String message, Throwable t, Object ... args) {
        this.logger.accept(t, () -> String.format(message, args));
    }
}

