/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.launcher.main;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.PreconditionViolationException;
import org.junit.gen5.engine.DiscoveryFilter;
import org.junit.gen5.engine.DiscoverySelector;
import org.junit.gen5.engine.Filter;
import org.junit.gen5.launcher.EngineIdFilter;
import org.junit.gen5.launcher.PostDiscoveryFilter;
import org.junit.gen5.launcher.TestDiscoveryRequest;
import org.junit.gen5.launcher.main.DiscoveryRequest;

@API(value=API.Usage.Experimental)
public final class TestDiscoveryRequestBuilder {
    private List<DiscoverySelector> selectors = new LinkedList<DiscoverySelector>();
    private List<EngineIdFilter> engineIdFilters = new LinkedList<EngineIdFilter>();
    private List<DiscoveryFilter<?>> discoveryFilters = new LinkedList();
    private List<PostDiscoveryFilter> postDiscoveryFilters = new LinkedList<PostDiscoveryFilter>();

    public static TestDiscoveryRequestBuilder request() {
        return new TestDiscoveryRequestBuilder();
    }

    public TestDiscoveryRequestBuilder select(DiscoverySelector ... elements) {
        if (elements != null) {
            this.select(Arrays.asList(elements));
        }
        return this;
    }

    public TestDiscoveryRequestBuilder select(List<DiscoverySelector> elements) {
        if (elements != null) {
            this.selectors.addAll(elements);
        }
        return this;
    }

    public TestDiscoveryRequestBuilder filter(Filter<?> ... filters) {
        if (filters != null) {
            Arrays.stream(filters).forEach(this::storeFilter);
        }
        return this;
    }

    private void storeFilter(Filter<?> filter) {
        if (filter instanceof EngineIdFilter) {
            this.engineIdFilters.add((EngineIdFilter)filter);
        } else if (filter instanceof PostDiscoveryFilter) {
            this.postDiscoveryFilters.add((PostDiscoveryFilter)filter);
        } else if (filter instanceof DiscoveryFilter) {
            this.discoveryFilters.add((DiscoveryFilter)filter);
        } else {
            throw new PreconditionViolationException("Filter must implement " + EngineIdFilter.class.getSimpleName() + ", " + PostDiscoveryFilter.class.getSimpleName() + ", or " + DiscoveryFilter.class.getSimpleName() + ".");
        }
    }

    public TestDiscoveryRequest build() {
        DiscoveryRequest discoveryRequest = new DiscoveryRequest();
        discoveryRequest.addSelectors(this.selectors);
        discoveryRequest.addEngineIdFilters(this.engineIdFilters);
        discoveryRequest.addFilters(this.discoveryFilters);
        discoveryRequest.addPostFilters(this.postDiscoveryFilters);
        return discoveryRequest;
    }
}

