/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4;

import java.util.logging.Logger;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.engine.EngineDiscoveryRequest;
import org.junit.gen5.engine.EngineExecutionListener;
import org.junit.gen5.engine.ExecutionRequest;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestEngine;
import org.junit.gen5.engine.TestExecutionResult;
import org.junit.gen5.engine.junit4.descriptor.RunnerTestDescriptor;
import org.junit.gen5.engine.junit4.discovery.JUnit4DiscoveryRequestResolver;
import org.junit.gen5.engine.junit4.execution.RunnerExecutor;
import org.junit.gen5.engine.support.descriptor.EngineDescriptor;

@API(value=API.Usage.Experimental)
public class JUnit4TestEngine
implements TestEngine {
    private static final Logger LOG = Logger.getLogger(JUnit4TestEngine.class.getName());

    public String getId() {
        return "junit4";
    }

    public TestDescriptor discover(EngineDiscoveryRequest discoveryRequest) {
        EngineDescriptor engineDescriptor = new EngineDescriptor("junit4", "JUnit 4");
        new JUnit4DiscoveryRequestResolver(engineDescriptor, LOG).resolve(discoveryRequest);
        return engineDescriptor;
    }

    public void execute(ExecutionRequest request) {
        EngineExecutionListener engineExecutionListener = request.getEngineExecutionListener();
        TestDescriptor engineTestDescriptor = request.getRootTestDescriptor();
        engineExecutionListener.executionStarted(engineTestDescriptor);
        RunnerExecutor runnerExecutor = new RunnerExecutor(engineExecutionListener, LOG);
        this.executeAllChildren(runnerExecutor, engineTestDescriptor);
        engineExecutionListener.executionFinished(engineTestDescriptor, TestExecutionResult.successful());
    }

    private void executeAllChildren(RunnerExecutor runnerExecutor, TestDescriptor engineTestDescriptor) {
        engineTestDescriptor.getChildren().stream().map(RunnerTestDescriptor.class::cast).forEach(runnerExecutor::execute);
    }
}

