/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.descriptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.junit.experimental.categories.Category;
import org.junit.gen5.commons.meta.API;
import org.junit.gen5.commons.util.CollectionUtils;
import org.junit.gen5.commons.util.FunctionUtils;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.TestSource;
import org.junit.gen5.engine.TestTag;
import org.junit.gen5.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.gen5.engine.support.descriptor.JavaSource;
import org.junit.runner.Description;

@API(value=API.Usage.Internal)
public class JUnit4TestDescriptor
extends AbstractTestDescriptor {
    public static final String ENGINE_ID = "junit4";
    public static final char DEFAULT_SEPARATOR = '/';
    private final Description description;

    public JUnit4TestDescriptor(TestDescriptor parent, char separator, String uniqueIdSuffix, Description description) {
        this(parent, separator, uniqueIdSuffix, description, JUnit4TestDescriptor.toJavaSource(description));
    }

    JUnit4TestDescriptor(TestDescriptor parent, char separator, String uniqueIdSuffix, Description description, Optional<? extends TestSource> source) {
        super(parent.getUniqueId() + separator + uniqueIdSuffix);
        this.description = description;
        source.ifPresent(arg_0 -> ((JUnit4TestDescriptor)this).setSource(arg_0));
    }

    public Description getDescription() {
        return this.description;
    }

    public String getName() {
        return this.description.getDisplayName();
    }

    public String getDisplayName() {
        String methodName = this.description.getMethodName();
        return methodName != null ? methodName : this.description.getDisplayName();
    }

    public boolean isTest() {
        return this.description.isTest();
    }

    public boolean isContainer() {
        return this.description.isSuite();
    }

    public Set<TestTag> getTags() {
        LinkedHashSet<TestTag> result = new LinkedHashSet<TestTag>();
        this.getParent().ifPresent(parent -> result.addAll(parent.getTags()));
        this.getDeclaredCategories().ifPresent(categoryClasses -> Arrays.stream(categoryClasses).map(ReflectionUtils::getAllAssignmentCompatibleClasses).flatMap(Collection::stream).distinct().map(Class::getName).map(TestTag::new).forEachOrdered(result::add));
        return result;
    }

    private Optional<Class<?>[]> getDeclaredCategories() {
        Category annotation = (Category)this.description.getAnnotation(Category.class);
        return Optional.ofNullable(annotation).map(Category::value);
    }

    private static Optional<JavaSource> toJavaSource(Description description) {
        Class testClass = description.getTestClass();
        if (testClass != null) {
            String methodName = description.getMethodName();
            if (methodName != null) {
                return Optional.of(JUnit4TestDescriptor.toJavaMethodSource(testClass, methodName));
            }
            return Optional.of(new JavaSource(testClass));
        }
        return Optional.empty();
    }

    private static JavaSource toJavaMethodSource(Class<?> testClass, String methodName) {
        List methods = ReflectionUtils.findMethods(testClass, (Predicate)FunctionUtils.where(Method::getName, Predicate.isEqual(methodName)));
        if (methods.size() == 1) {
            return new JavaSource((Method)CollectionUtils.getOnlyElement((Collection)methods));
        }
        return new JavaSource(testClass);
    }
}

