/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.discovery;

import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Predicate;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.junit4.discovery.IsPotentialJUnit4TestMethod;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

class DefensiveAllDefaultPossibilitiesBuilder
extends AllDefaultPossibilitiesBuilder {
    private final AnnotatedBuilder annotatedBuilder = new DefensiveAnnotatedBuilder((RunnerBuilder)this);
    private final DefensiveJUnit4Builder defensiveJUnit4Builder = new DefensiveJUnit4Builder();

    DefensiveAllDefaultPossibilitiesBuilder() {
        super(true);
    }

    protected AnnotatedBuilder annotatedBuilder() {
        return this.annotatedBuilder;
    }

    protected JUnit4Builder junit4Builder() {
        return this.defensiveJUnit4Builder;
    }

    private static class DefensiveJUnit4Builder
    extends JUnit4Builder {
        private final Predicate<Method> hasTestAnnotation = new IsPotentialJUnit4TestMethod();

        private DefensiveJUnit4Builder() {
        }

        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            if (this.containsTestMethods(testClass)) {
                return super.runnerForClass(testClass);
            }
            return null;
        }

        private boolean containsTestMethods(Class<?> testClass) {
            List testMethods = ReflectionUtils.findMethods(testClass, this.hasTestAnnotation);
            return !testMethods.isEmpty();
        }
    }

    private static class DefensiveAnnotatedBuilder
    extends AnnotatedBuilder {
        public DefensiveAnnotatedBuilder(RunnerBuilder suiteBuilder) {
            super(suiteBuilder);
        }

        public Runner buildRunner(Class<? extends Runner> runnerClass, Class<?> testClass) throws Exception {
            if ("org.junit.gen5.junit4.runner.JUnit5".equals(runnerClass.getName())) {
                return null;
            }
            return super.buildRunner(runnerClass, testClass);
        }
    }
}

