/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.discovery;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.junit4.descriptor.JUnit4TestDescriptor;
import org.junit.gen5.engine.junit4.descriptor.RunnerTestDescriptor;
import org.junit.gen5.engine.junit4.discovery.DefensiveAllDefaultPossibilitiesBuilder;
import org.junit.gen5.engine.junit4.discovery.OrFilter;
import org.junit.gen5.engine.junit4.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.gen5.engine.junit4.discovery.TestClassRequest;
import org.junit.gen5.engine.junit4.discovery.UniqueIdReader;
import org.junit.gen5.engine.junit4.discovery.UniqueIdStringifier;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;

class TestClassRequestResolver {
    private final TestDescriptor engineDescriptor;
    private final Logger logger;
    private final UniqueIdReader uniqueIdReader;
    private final UniqueIdStringifier uniqueIdStringifier = new UniqueIdStringifier();

    TestClassRequestResolver(TestDescriptor engineDescriptor, Logger logger) {
        this.engineDescriptor = engineDescriptor;
        this.logger = logger;
        this.uniqueIdReader = new UniqueIdReader(logger);
    }

    void populateEngineDescriptorFrom(Set<TestClassRequest> requests) {
        DefensiveAllDefaultPossibilitiesBuilder runnerBuilder = new DefensiveAllDefaultPossibilitiesBuilder();
        for (TestClassRequest request : requests) {
            Class<?> testClass = request.getTestClass();
            Runner runner = runnerBuilder.safeRunnerForClass(testClass);
            if (runner == null) continue;
            this.addRunnerTestDescriptor(request, testClass, runner);
        }
    }

    private void addRunnerTestDescriptor(TestClassRequest request, Class<?> testClass, Runner runner) {
        RunnerTestDescriptor runnerTestDescriptor = this.determineRunnerTestDescriptor(testClass, runner, request.getFilters());
        this.engineDescriptor.addChild((TestDescriptor)runnerTestDescriptor);
    }

    private RunnerTestDescriptor determineRunnerTestDescriptor(Class<?> testClass, Runner runner, List<RunnerTestDescriptorAwareFilter> filters) {
        RunnerTestDescriptor runnerTestDescriptor = this.createCompleteRunnerTestDescriptor(testClass, runner);
        if (!filters.isEmpty()) {
            if (runner instanceof Filterable) {
                Filter filter = this.createOrFilter(filters, runnerTestDescriptor);
                Runner filteredRunner = runnerTestDescriptor.toRequest().filterWith(filter).getRunner();
                runnerTestDescriptor = this.createCompleteRunnerTestDescriptor(testClass, filteredRunner);
            } else {
                this.logger.warning(() -> "Runner " + runner.getClass().getName() + " (used on " + testClass.getName() + ") does not support filtering" + " and will therefore be run completely.");
            }
        }
        return runnerTestDescriptor;
    }

    private Filter createOrFilter(List<RunnerTestDescriptorAwareFilter> filters, RunnerTestDescriptor runnerTestDescriptor) {
        filters.stream().forEach(filter -> filter.initialize(runnerTestDescriptor));
        return new OrFilter(filters);
    }

    private RunnerTestDescriptor createCompleteRunnerTestDescriptor(Class<?> testClass, Runner runner) {
        RunnerTestDescriptor runnerTestDescriptor = new RunnerTestDescriptor(this.engineDescriptor, testClass, runner);
        this.addChildrenRecursively(runnerTestDescriptor);
        return runnerTestDescriptor;
    }

    private void addChildrenRecursively(JUnit4TestDescriptor parent) {
        ArrayList children = parent.getDescription().getChildren();
        Map childrenByUniqueId = children.stream().collect(Collectors.groupingBy(this.uniqueIdReader.andThen(this.uniqueIdStringifier), LinkedHashMap::new, Collectors.toCollection(ArrayList::new)));
        for (Map.Entry entry : childrenByUniqueId.entrySet()) {
            String uniqueId = (String)entry.getKey();
            List childrenWithSameUniqueId = (List)entry.getValue();
            IntFunction<String> uniqueIdGenerator = this.determineUniqueIdGenerator(uniqueId, childrenWithSameUniqueId);
            for (int index = 0; index < childrenWithSameUniqueId.size(); ++index) {
                String reallyUniqueId = uniqueIdGenerator.apply(index);
                Description description = (Description)childrenWithSameUniqueId.get(index);
                JUnit4TestDescriptor child = new JUnit4TestDescriptor((TestDescriptor)parent, '/', reallyUniqueId, description);
                parent.addChild((TestDescriptor)child);
                this.addChildrenRecursively(child);
            }
        }
    }

    private IntFunction<String> determineUniqueIdGenerator(String uniqueId, List<Description> childrenWithSameUniqueId) {
        if (childrenWithSameUniqueId.size() == 1) {
            return index -> uniqueId;
        }
        return index -> uniqueId + "[" + index + "]";
    }
}

