/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.discovery;

import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.gen5.engine.TestDescriptor;
import org.junit.gen5.engine.junit4.descriptor.JUnit4TestDescriptor;
import org.junit.gen5.engine.junit4.descriptor.RunnerTestDescriptor;
import org.junit.gen5.engine.junit4.discovery.RunnerTestDescriptorAwareFilter;
import org.junit.runner.Description;

class UniqueIdFilter
extends RunnerTestDescriptorAwareFilter {
    private final String uniqueId;
    private Deque<Description> path;
    private Set<Description> descendants;

    public UniqueIdFilter(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    @Override
    void initialize(RunnerTestDescriptor runnerTestDescriptor) {
        Optional identifiedTestDescriptor = runnerTestDescriptor.findByUniqueId(this.uniqueId);
        this.descendants = this.determineDescendants(identifiedTestDescriptor);
        this.path = this.determinePath(runnerTestDescriptor, identifiedTestDescriptor);
    }

    private Deque<Description> determinePath(RunnerTestDescriptor runnerTestDescriptor, Optional<? extends TestDescriptor> identifiedTestDescriptor) {
        LinkedList<Description> path = new LinkedList<Description>();
        Optional current = identifiedTestDescriptor;
        while (current.isPresent() && !current.get().equals((Object)runnerTestDescriptor)) {
            path.addFirst(((JUnit4TestDescriptor)current.get()).getDescription());
            current = current.get().getParent();
        }
        return path;
    }

    private Set<Description> determineDescendants(Optional<? extends TestDescriptor> identifiedTestDescriptor) {
        if (identifiedTestDescriptor.isPresent()) {
            return identifiedTestDescriptor.get().allDescendants().stream().map(JUnit4TestDescriptor.class::cast).map(JUnit4TestDescriptor::getDescription).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public boolean shouldRun(Description description) {
        return this.path.contains(description) || this.descendants.contains(description);
    }

    public String describe() {
        return "Unique ID " + this.uniqueId;
    }
}

