/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.discovery;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Logger;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.runner.Description;

class UniqueIdReader
implements Function<Description, Serializable> {
    private final Logger logger;
    private final String fieldName;

    UniqueIdReader(Logger logger) {
        this(logger, "fUniqueId");
    }

    UniqueIdReader(Logger logger, String fieldName) {
        this.logger = logger;
        this.fieldName = fieldName;
    }

    @Override
    public Serializable apply(Description description) {
        Optional result = ReflectionUtils.readFieldValue(Description.class, (String)this.fieldName, (Object)description);
        return result.map(Serializable.class::cast).orElseGet(() -> {
            this.logger.warning(() -> String.format("Could not read unique id for Description, using display name instead: %s", description.toString()));
            return description.getDisplayName();
        });
    }
}

