/*
 * Decompiled with CFR 0.152.
 */
package org.junit.gen5.engine.junit4.discovery;

import java.util.Optional;
import java.util.logging.Logger;
import org.junit.gen5.commons.util.ReflectionUtils;
import org.junit.gen5.engine.discovery.UniqueIdSelector;
import org.junit.gen5.engine.junit4.discovery.DiscoverySelectorResolver;
import org.junit.gen5.engine.junit4.discovery.TestClassCollector;
import org.junit.gen5.engine.junit4.discovery.UniqueIdFilter;

class UniqueIdSelectorResolver
extends DiscoverySelectorResolver<UniqueIdSelector> {
    private static final String ENGINE_PREFIX = "junit4:";
    private final Logger logger;

    UniqueIdSelectorResolver(Logger logger) {
        super(UniqueIdSelector.class);
        this.logger = logger;
    }

    @Override
    void resolve(UniqueIdSelector selector, TestClassCollector collector) {
        String uniqueId = selector.getUniqueId();
        if ("junit4".equals(uniqueId)) {
            this.logger.warning(() -> String.format("Unresolvable Unique ID (%s): Cannot resolve the engine's unique ID", uniqueId));
        } else if (uniqueId.startsWith(ENGINE_PREFIX)) {
            String testClassName = this.determineTestClassName(uniqueId, ENGINE_PREFIX);
            this.resolveIntoFilteredTestClass(testClassName, uniqueId, collector);
        }
    }

    private void resolveIntoFilteredTestClass(String testClassName, String uniqueId, TestClassCollector collector) {
        Optional testClass = ReflectionUtils.loadClass((String)testClassName);
        if (testClass.isPresent()) {
            collector.addFiltered((Class)testClass.get(), new UniqueIdFilter(uniqueId));
        } else {
            this.logger.warning(() -> String.format("Unresolvable Unique ID (%s): Unknown class %s", uniqueId, testClassName));
        }
    }

    private String determineTestClassName(String uniqueId, String enginePrefix) {
        int endIndex = uniqueId.indexOf(47);
        if (endIndex >= 0) {
            return uniqueId.substring(enginePrefix.length(), endIndex);
        }
        return uniqueId.substring(enginePrefix.length());
    }
}

