/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.animal_sniffer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.jvnet.animal_sniffer.ClassFileVisitor;
import org.jvnet.animal_sniffer.Clazz;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class SignatureChecker
extends ClassFileVisitor {
    private final Map classes = new HashMap();
    private final Set ignoredPackages;

    public static void main(String[] args) throws Exception {
        HashSet<String> ignoredPackages = new HashSet<String>();
        ignoredPackages.add("org/jvnet/animal_sniffer");
        ignoredPackages.add("org/objectweb/*");
        new SignatureChecker(new FileInputStream("signature"), ignoredPackages).process(new File("target/classes"));
    }

    public SignatureChecker(InputStream in, Set ignoredPackages) throws IOException {
        this.ignoredPackages = ignoredPackages;
        try {
            ObjectInputStream ois = new ObjectInputStream(new GZIPInputStream(in));
            while (true) {
                Clazz c;
                if ((c = (Clazz)ois.readObject()) == null) {
                    return;
                }
                this.classes.put(c.name, c);
            }
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    protected void process(final String name, InputStream image) throws IOException {
        ClassReader cr = new ClassReader(image);
        final HashSet warned = new HashSet();
        cr.accept((ClassVisitor)new EmptyVisitor(){

            public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
                return new EmptyVisitor(){
                    boolean ignoreError = false;

                    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                        if (desc.equals("Lorg/jvnet/animal_sniffer/IgnoreJRERequirement;")) {
                            this.ignoreError = true;
                        }
                        return super.visitAnnotation(desc, visible);
                    }

                    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                        this.check(owner, name + desc);
                    }

                    public void visitTypeInsn(int opcode, String type) {
                        if (this.shouldBeIgnored(type)) {
                            return;
                        }
                        if (type.startsWith("[")) {
                            return;
                        }
                        Clazz sigs = (Clazz)SignatureChecker.this.classes.get(type);
                        if (sigs == null) {
                            this.error("Undefined reference: " + type);
                        }
                    }

                    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                        this.check(owner, name + '#' + desc);
                    }

                    private void check(String owner, String sig) {
                        if (this.shouldBeIgnored(owner)) {
                            return;
                        }
                        if (this.find((Clazz)SignatureChecker.this.classes.get(owner), sig)) {
                            return;
                        }
                        this.error("Undefined reference: " + owner + '.' + sig);
                    }

                    private boolean shouldBeIgnored(String type) {
                        if (this.ignoreError) {
                            return true;
                        }
                        if (type.startsWith("[")) {
                            return true;
                        }
                        int idx = type.lastIndexOf(47);
                        if (idx < 0) {
                            return SignatureChecker.this.ignoredPackages.contains("");
                        }
                        String pkg = type.substring(0, idx);
                        if (SignatureChecker.this.ignoredPackages.contains(pkg)) {
                            return true;
                        }
                        while (!SignatureChecker.this.ignoredPackages.contains(pkg + "/*")) {
                            idx = pkg.lastIndexOf(47);
                            if (idx < 0) {
                                return false;
                            }
                            pkg = pkg.substring(0, idx);
                        }
                        return true;
                    }
                };
            }

            private boolean find(Clazz c, String sig) {
                if (c == null) {
                    return false;
                }
                if (c.signatures.contains(sig)) {
                    return true;
                }
                if (sig.startsWith("<")) {
                    return false;
                }
                if (this.find((Clazz)SignatureChecker.this.classes.get(c.superClass), sig)) {
                    return true;
                }
                if (c.superInterfaces != null) {
                    for (int i = 0; i < c.superInterfaces.length; ++i) {
                        if (!this.find((Clazz)SignatureChecker.this.classes.get(c.superInterfaces[i]), sig)) continue;
                        return true;
                    }
                }
                return false;
            }

            private void error(String msg) {
                if (warned.add(msg)) {
                    SignatureChecker.this.reportError(msg + " in " + name);
                }
            }
        }, 0);
    }

    protected void reportError(String msg) {
        System.err.println(msg);
    }
}

