/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.animal_sniffer.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jvnet.animal_sniffer.SignatureBuilder;

public class BuildSignatureTask
extends Task {
    private File dest;
    private File javaHome;

    public void setDest(File dest) {
        this.dest = dest;
    }

    public void setJavaHome(File javaHome) {
        this.javaHome = javaHome;
    }

    public void execute() throws BuildException {
        try {
            SignatureBuilder builder = new SignatureBuilder(new FileOutputStream(this.dest));
            this.process(builder, "lib/rt.jar");
            this.process(builder, "lib/jce.jar");
            this.process(builder, "lib/jsse.jar");
            builder.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void process(SignatureBuilder builder, String name) throws IOException {
        File f;
        if (this.javaHome == null) {
            this.javaHome = new File(System.getProperty("java.home"));
        }
        if ((f = new File(this.javaHome, name)).exists()) {
            builder.process(f);
        }
    }
}

