/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.animal_sniffer.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.AbstractArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.jvnet.animal_sniffer.ClassFileVisitor;
import org.jvnet.animal_sniffer.PackageListBuilder;
import org.jvnet.animal_sniffer.SignatureChecker;
import org.jvnet.animal_sniffer.maven.Artifact;

public class CheckSignatureMojo
extends AbstractMojo {
    protected List classpathElements;
    protected File outputDirectory;
    protected Artifact signature;
    protected ArtifactResolver resolver;
    protected MavenProject project;
    protected ArtifactRepository localRepository;
    protected ArtifactFactory artifactFactory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.getLog().info((CharSequence)("Checking unresolved references to " + this.signature));
            final boolean[] hadError = new boolean[1];
            org.apache.maven.artifact.Artifact a = this.signature.createArtifact(this.artifactFactory);
            this.resolver.resolve(a, this.project.getRemoteArtifactRepositories(), this.localRepository);
            new SignatureChecker(new FileInputStream(a.getFile()), this.buildPackageList()){

                protected void reportError(String msg) {
                    hadError[0] = true;
                    CheckSignatureMojo.this.getLog().error((CharSequence)msg);
                }

                protected void process(String name, InputStream image) throws IOException {
                    CheckSignatureMojo.this.getLog().debug((CharSequence)name);
                    super.process(name, image);
                }
            }.process(this.outputDirectory);
            if (hadError[0]) {
                throw new MojoExecutionException("Signature errors found. Verify them and put @IgnoreJRERequirement on them.");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to check signatures", (Exception)e);
        }
        catch (AbstractArtifactResolutionException e) {
            throw new MojoExecutionException("Failed to obtain signature: " + this.signature, (Exception)((Object)e));
        }
    }

    private Set buildPackageList() throws IOException {
        PackageListBuilder plb = new PackageListBuilder();
        this.apply(plb);
        return plb.packages;
    }

    private void apply(ClassFileVisitor v) throws IOException {
        v.process(this.outputDirectory);
        Iterator itr = this.classpathElements.iterator();
        while (itr.hasNext()) {
            String path = (String)itr.next();
            v.process(new File(path));
        }
    }
}

