/*
 * Decompiled with CFR 0.152.
 */
package org.kaazing.gateway.management.service;

import java.util.Collection;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.kaazing.gateway.management.gateway.GatewayManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementBean;
import org.kaazing.gateway.management.service.ServiceManagementBeanFactorySpi;
import org.kaazing.gateway.service.ServiceContext;

public final class ServiceManagementBeanFactory {
    private ConcurrentMap<String, ServiceManagementBeanFactorySpi> serviceMgmtFactoriesByType;

    private ServiceManagementBeanFactory(ConcurrentMap<String, ServiceManagementBeanFactorySpi> serviceMgmtFactoriesByType) {
        this.serviceMgmtFactoriesByType = serviceMgmtFactoriesByType;
    }

    private static ServiceManagementBeanFactory newServiceManagmentBeanFactory(ServiceLoader<ServiceManagementBeanFactorySpi> serviceFactories) {
        ConcurrentHashMap<String, ServiceManagementBeanFactorySpi> serviceMgmtFactoriesByType = new ConcurrentHashMap<String, ServiceManagementBeanFactorySpi>();
        for (ServiceManagementBeanFactorySpi ServiceManagmentBeanFactory : serviceFactories) {
            Collection<String> serviceTypes = ServiceManagmentBeanFactory.getServiceTypes();
            for (String serviceType : serviceTypes) {
                ServiceManagementBeanFactorySpi oldServiceManagmentBeanFactory = serviceMgmtFactoriesByType.putIfAbsent(serviceType, ServiceManagmentBeanFactory);
                if (oldServiceManagmentBeanFactory == null) continue;
                throw new RuntimeException(String.format("Duplicate type service managment bean factory: %s", serviceType));
            }
        }
        return new ServiceManagementBeanFactory(serviceMgmtFactoriesByType);
    }

    public static ServiceManagementBeanFactory newServiceManagementBeanFactory() {
        return ServiceManagementBeanFactory.newServiceManagmentBeanFactory(ServiceLoader.load(ServiceManagementBeanFactorySpi.class));
    }

    public static ServiceManagementBeanFactory newServiceManagementBeanFactory(ClassLoader loader) {
        return ServiceManagementBeanFactory.newServiceManagmentBeanFactory(ServiceLoader.load(ServiceManagementBeanFactorySpi.class, loader));
    }

    public ServiceManagementBean newServiceManagementBean(String serviceType, GatewayManagementBean gatewayManagementBean, ServiceContext serviceContext) {
        ServiceManagementBeanFactorySpi serviceFactory = (ServiceManagementBeanFactorySpi)this.serviceMgmtFactoriesByType.get(serviceType);
        ServiceManagementBean result = serviceFactory == null ? new ServiceManagementBean.DefaultServiceManagementBean(gatewayManagementBean, serviceContext){} : serviceFactory.newServiceManagementBean(gatewayManagementBean, serviceContext);
        return result;
    }
}

