/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.admin.client.resource.AuthorizationResource;
import org.keycloak.admin.client.resource.ClientAttributeCertificateResource;
import org.keycloak.admin.client.resource.ProtocolMappersResource;
import org.keycloak.admin.client.resource.RoleMappingResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.adapters.action.GlobalRequestResult;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.ClientScopeRepresentation;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.ManagementPermissionRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.keycloak.representations.idm.UserSessionRepresentation;

public interface ClientResource {
    @PUT
    @Path(value="/management/permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ManagementPermissionReference setPermissions(ManagementPermissionRepresentation var1);

    @GET
    @Path(value="/management/permissions")
    @Produces(value={"application/json"})
    public ManagementPermissionReference getPermissions();

    @Path(value="protocol-mappers")
    public ProtocolMappersResource getProtocolMappers();

    @GET
    @Produces(value={"application/json"})
    public ClientRepresentation toRepresentation();

    @PUT
    @Consumes(value={"application/json"})
    public void update(ClientRepresentation var1);

    @DELETE
    public void remove();

    @POST
    @Path(value="client-secret")
    @Produces(value={"application/json"})
    public CredentialRepresentation generateNewSecret();

    @GET
    @Path(value="client-secret")
    @Produces(value={"application/json"})
    public CredentialRepresentation getSecret();

    @Path(value="registration-access-token")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public ClientRepresentation regenerateRegistrationAccessToken();

    @Path(value="certificates/{attr}")
    public ClientAttributeCertificateResource getCertficateResource(@PathParam(value="attr") String var1);

    @GET
    @NoCache
    @Path(value="installation/providers/{providerId}")
    public String getInstallationProvider(@PathParam(value="providerId") String var1);

    @Path(value="session-count")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Integer> getApplicationSessionCount();

    @Path(value="user-sessions")
    @GET
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getUserSessions(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);

    @Path(value="offline-session-count")
    @GET
    @Produces(value={"application/json"})
    public Map<String, Long> getOfflineSessionCount();

    @Path(value="offline-sessions")
    @GET
    @Produces(value={"application/json"})
    public List<UserSessionRepresentation> getOfflineUserSessions(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);

    @POST
    @Path(value="push-revocation")
    @Produces(value={"application/json"})
    public void pushRevocation();

    @Path(value="/scope-mappings")
    public RoleMappingResource getScopeMappings();

    @Path(value="/roles")
    public RolesResource roles();

    @GET
    @Produces(value={"application/json"})
    @Path(value="default-client-scopes")
    public List<ClientScopeRepresentation> getDefaultClientScopes();

    @PUT
    @Path(value="default-client-scopes/{clientScopeId}")
    public void addDefaultClientScope(@PathParam(value="clientScopeId") String var1);

    @DELETE
    @Path(value="default-client-scopes/{clientScopeId}")
    public void removeDefaultClientScope(@PathParam(value="clientScopeId") String var1);

    @GET
    @Produces(value={"application/json"})
    @Path(value="optional-client-scopes")
    public List<ClientScopeRepresentation> getOptionalClientScopes();

    @PUT
    @Path(value="optional-client-scopes/{clientScopeId}")
    public void addOptionalClientScope(@PathParam(value="clientScopeId") String var1);

    @DELETE
    @Path(value="optional-client-scopes/{clientScopeId}")
    public void removeOptionalClientScope(@PathParam(value="clientScopeId") String var1);

    @Path(value="/service-account-user")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public UserRepresentation getServiceAccountUser();

    @Path(value="nodes")
    @POST
    @Consumes(value={"application/json"})
    public void registerNode(Map<String, String> var1);

    @Path(value="nodes/{node}")
    @DELETE
    public void unregisterNode(@PathParam(value="node") String var1);

    @Path(value="test-nodes-available")
    @GET
    @Produces(value={"application/json"})
    public GlobalRequestResult testNodesAvailable();

    @Path(value="/authz/resource-server")
    public AuthorizationResource authorization();
}

