/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.common.util;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.keycloak.common.constants.KerberosConstants;
import org.keycloak.common.util.Environment;
import org.keycloak.common.util.KerberosSerializationUtils;

public abstract class KerberosJdkProvider {
    public abstract Configuration createJaasConfigurationForServer(String var1, String var2, boolean var3);

    public abstract Configuration createJaasConfigurationForUsernamePasswordLogin(boolean var1);

    public abstract KerberosTicket gssCredentialToKerberosTicket(KerberosTicket var1, GSSCredential var2);

    public GSSCredential kerberosTicketToGSSCredential(KerberosTicket kerberosTicket) {
        return this.kerberosTicketToGSSCredential(kerberosTicket, 0, 1);
    }

    public GSSCredential kerberosTicketToGSSCredential(KerberosTicket kerberosTicket, final int lifetime, final int usage) {
        try {
            final GSSManager gssManager = GSSManager.getInstance();
            KerberosPrincipal kerberosPrincipal = kerberosTicket.getClient();
            String krbPrincipalName = kerberosTicket.getClient().getName();
            final GSSName gssName = gssManager.createName(krbPrincipalName, KerberosConstants.KRB5_NAME_OID);
            Set<KerberosPrincipal> principals = Collections.singleton(kerberosPrincipal);
            Set<GSSName> publicCreds = Collections.singleton(gssName);
            Set<KerberosTicket> privateCreds = Collections.singleton(kerberosTicket);
            Subject subject = new Subject(false, principals, publicCreds, privateCreds);
            return Subject.doAs(subject, new PrivilegedExceptionAction<GSSCredential>(){

                @Override
                public GSSCredential run() throws Exception {
                    return gssManager.createCredential(gssName, lifetime, KerberosConstants.KRB5_OID, usage);
                }
            });
        }
        catch (Exception e) {
            throw new KerberosSerializationUtils.KerberosSerializationException("Unexpected exception during convert KerberosTicket to GSSCredential", e);
        }
    }

    public static KerberosJdkProvider getProvider() {
        if (Environment.IS_IBM_JAVA) {
            return new IBMJDKProvider();
        }
        return new SunJDKProvider();
    }

    private static class IBMJDKProvider
    extends KerberosJdkProvider {
        private IBMJDKProvider() {
        }

        @Override
        public Configuration createJaasConfigurationForServer(String keytab, final String serverPrincipal, final boolean debug) {
            final String keytabUrl = this.getKeytabURL(keytab);
            return new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("noAddress", "true");
                    options.put("credsType", "acceptor");
                    options.put("useKeytab", keytabUrl);
                    options.put("principal", serverPrincipal);
                    options.put("debug", String.valueOf(debug));
                    AppConfigurationEntry kerberosLMConfiguration = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                    return new AppConfigurationEntry[]{kerberosLMConfiguration};
                }
            };
        }

        private String getKeytabURL(String keytab) {
            try {
                return new File(keytab).toURI().toURL().toString();
            }
            catch (MalformedURLException mfe) {
                System.err.println("Invalid keytab location specified in configuration: " + keytab);
                mfe.printStackTrace();
                return keytab;
            }
        }

        @Override
        public Configuration createJaasConfigurationForUsernamePasswordLogin(final boolean debug) {
            return new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("credsType", "initiator");
                    options.put("noAddress", "true");
                    options.put("debug", String.valueOf(debug));
                    AppConfigurationEntry kerberosLMConfiguration = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                    return new AppConfigurationEntry[]{kerberosLMConfiguration};
                }
            };
        }

        @Override
        public KerberosTicket gssCredentialToKerberosTicket(KerberosTicket kerberosTicket, GSSCredential gssCredential) {
            if (kerberosTicket == null) {
                throw new KerberosSerializationUtils.KerberosSerializationException("Not available kerberosTicket in subject credentials in IBM JDK");
            }
            return kerberosTicket;
        }
    }

    private static class SunJDKProvider
    extends KerberosJdkProvider {
        private SunJDKProvider() {
        }

        @Override
        public Configuration createJaasConfigurationForServer(final String keytab, final String serverPrincipal, final boolean debug) {
            return new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("storeKey", "true");
                    options.put("doNotPrompt", "true");
                    options.put("isInitiator", "false");
                    options.put("useKeyTab", "true");
                    options.put("keyTab", keytab);
                    options.put("principal", serverPrincipal);
                    options.put("debug", String.valueOf(debug));
                    AppConfigurationEntry kerberosLMConfiguration = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                    return new AppConfigurationEntry[]{kerberosLMConfiguration};
                }
            };
        }

        @Override
        public Configuration createJaasConfigurationForUsernamePasswordLogin(final boolean debug) {
            return new Configuration(){

                @Override
                public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("storeKey", "true");
                    options.put("debug", String.valueOf(debug));
                    AppConfigurationEntry kerberosLMConfiguration = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                    return new AppConfigurationEntry[]{kerberosLMConfiguration};
                }
            };
        }

        @Override
        public KerberosTicket gssCredentialToKerberosTicket(KerberosTicket kerberosTicket, GSSCredential gssCredential) {
            try {
                Class<?> gssUtil = Class.forName("com.sun.security.jgss.GSSUtil");
                Method createSubject = gssUtil.getMethod("createSubject", GSSName.class, GSSCredential.class);
                Subject subject = (Subject)createSubject.invoke(null, null, gssCredential);
                Set<KerberosTicket> kerberosTickets = subject.getPrivateCredentials(KerberosTicket.class);
                Iterator<KerberosTicket> iterator = kerberosTickets.iterator();
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                throw new KerberosSerializationUtils.KerberosSerializationException("Not available kerberosTicket in subject credentials. Subject was: " + subject.toString());
            }
            catch (KerberosSerializationUtils.KerberosSerializationException ke) {
                throw ke;
            }
            catch (Exception e) {
                throw new KerberosSerializationUtils.KerberosSerializationException("Unexpected error during convert GSSCredential to KerberosTicket", e);
            }
        }
    }
}

