/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import java.io.File;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class CachingOptions {
    public static final Option CACHE = new OptionBuilder<Mechanism>("cache", Mechanism.class).category(OptionCategory.CACHE).description("Defines the cache mechanism for high-availability. By default, a 'ispn' cache is used to create a cluster between multiple server nodes. A 'local' cache disables clustering and is intended for development and testing purposes.").defaultValue(Mechanism.ispn).buildTime(true).build();
    public static final Option CACHE_STACK = new OptionBuilder<Stack>("cache-stack", Stack.class).category(OptionCategory.CACHE).description("Define the default stack to use for cluster communication and node discovery. This option only takes effect if 'cache' is set to 'ispn'. Default: udp.").buildTime(true).build();
    public static final Option<File> CACHE_CONFIG_FILE = new OptionBuilder<File>("cache-config-file", File.class).category(OptionCategory.CACHE).description("Defines the file from which cache configuration should be loaded from. The configuration file is relative to the 'conf/' directory.").buildTime(true).build();

    public static enum Mechanism {
        ispn,
        local;

    }

    public static enum Stack {
        tcp,
        udp,
        kubernetes,
        ec2,
        azure,
        google;

    }
}

