/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.idm.store.ldap;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.keycloak.models.ModelException;

public class LDAPUtil {
    public static final String formatDate(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("You must provide a date.");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'.0Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return dateFormat.format(date);
    }

    public static final Date parseDate(String date) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        try {
            if (date.endsWith("Z")) {
                dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            } else {
                dateFormat.setTimeZone(TimeZone.getDefault());
            }
            return dateFormat.parse(date);
        }
        catch (Exception e) {
            throw new ModelException("Error converting ldap date.", (Throwable)e);
        }
    }

    public static String convertObjectGUIDToByteString(byte[] objectGUID) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < objectGUID.length; ++i) {
            String transformed = LDAPUtil.prefixZeros(objectGUID[i] & 0xFF);
            result.append("\\");
            result.append(transformed);
        }
        return result.toString();
    }

    public static String decodeObjectGUID(byte[] objectGUID) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(LDAPUtil.convertToDashedString(objectGUID));
        return displayStr.toString();
    }

    public static String decodeGuid(byte[] guid) {
        byte[] withBigEndian = new byte[]{guid[3], guid[2], guid[1], guid[0], guid[5], guid[4], guid[7], guid[6], guid[8], guid[9], guid[10], guid[11], guid[12], guid[13], guid[14], guid[15]};
        return LDAPUtil.convertToDashedString(withBigEndian);
    }

    private static String convertToDashedString(byte[] objectGUID) {
        StringBuilder displayStr = new StringBuilder();
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[3] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[2] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[1] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[0] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[5] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[4] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[7] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[6] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[8] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[9] & 0xFF));
        displayStr.append("-");
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[10] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[11] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[12] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[13] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[14] & 0xFF));
        displayStr.append(LDAPUtil.prefixZeros(objectGUID[15] & 0xFF));
        return displayStr.toString();
    }

    private static String prefixZeros(int value) {
        if (value <= 15) {
            StringBuilder sb = new StringBuilder("0");
            sb.append(Integer.toHexString(value));
            return sb.toString();
        }
        return Integer.toHexString(value);
    }
}

