/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.representations.idm.TestLdapConnectionRepresentation;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.managers.LDAPServerCapabilitiesManager;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class TestLdapConnectionResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    @Context
    protected KeycloakSession session;

    public TestLdapConnectionResource(RealmModel realm, AdminPermissionEvaluator auth) {
        this.auth = auth;
        this.realm = realm;
    }

    @POST
    @NoCache
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Deprecated
    public Response testLDAPConnection(@FormParam(value="action") String action, @FormParam(value="connectionUrl") String connectionUrl, @FormParam(value="bindDn") String bindDn, @FormParam(value="bindCredential") String bindCredential, @FormParam(value="useTruststoreSpi") String useTruststoreSpi, @FormParam(value="connectionTimeout") String connectionTimeout, @FormParam(value="componentId") String componentId, @FormParam(value="startTls") String startTls) {
        this.auth.realm().requireManageRealm();
        TestLdapConnectionRepresentation config = new TestLdapConnectionRepresentation(action, connectionUrl, bindDn, bindCredential, useTruststoreSpi, connectionTimeout, startTls, "simple");
        config.setComponentId(componentId);
        boolean result = LDAPServerCapabilitiesManager.testLDAP(config, this.session, this.realm);
        return result ? Response.noContent().build() : ErrorResponse.error((String)"LDAP test error", (Response.Status)Response.Status.BAD_REQUEST);
    }

    @POST
    @NoCache
    @Consumes(value={"application/json"})
    public Response testLDAPConnection(TestLdapConnectionRepresentation config) {
        boolean result = LDAPServerCapabilitiesManager.testLDAP(config, this.session, this.realm);
        return result ? Response.noContent().build() : ErrorResponse.error((String)"LDAP test error", (Response.Status)Response.Status.BAD_REQUEST);
    }
}

