/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap.mappers.membership;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPDn;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.EscapeStrategy;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapper;
import org.keycloak.storage.ldap.mappers.membership.CommonLDAPGroupMapperConfig;

public enum MembershipType {
    DN{

        @Override
        public Set<LDAPDn> getLDAPSubgroups(CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup) {
            CommonLDAPGroupMapperConfig config = groupMapper.getConfig();
            return this.getLDAPMembersWithParent(groupMapper.getLdapProvider(), ldapGroup, config.getMembershipLdapAttribute(), LDAPDn.fromString(config.getLDAPGroupsDn()));
        }

        protected Set<LDAPDn> getLDAPMembersWithParent(LDAPStorageProvider ldapProvider, LDAPObject ldapGroup, String membershipLdapAttribute, LDAPDn requiredParentDn) {
            Set<String> allMemberships = LDAPUtils.getExistingMemberships(ldapProvider, membershipLdapAttribute, ldapGroup);
            HashSet<LDAPDn> result = new HashSet<LDAPDn>();
            for (String membership : allMemberships) {
                LDAPDn childDn = LDAPDn.fromString(membership);
                if (!childDn.isDescendantOf(requiredParentDn)) continue;
                result.add(childDn);
            }
            return result;
        }

        @Override
        public List<UserModel> getGroupMembers(RealmModel realm, CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup, int firstResult, int maxResults) {
            LDAPStorageProvider ldapProvider = groupMapper.getLdapProvider();
            CommonLDAPGroupMapperConfig config = groupMapper.getConfig();
            LDAPDn usersDn = LDAPDn.fromString(ldapProvider.getLdapIdentityStore().getConfig().getUsersDn());
            Set<LDAPDn> userDns = this.getLDAPMembersWithParent(ldapProvider, ldapGroup, config.getMembershipLdapAttribute(), usersDn);
            if (userDns == null) {
                return Collections.emptyList();
            }
            if (userDns.size() <= firstResult) {
                return Collections.emptyList();
            }
            List<LDAPDn> dns = new ArrayList<LDAPDn>(userDns);
            int max = Math.min(dns.size(), firstResult + maxResults);
            dns = dns.subList(firstResult, max);
            LinkedList<String> usernames = new LinkedList<String>();
            LDAPConfig ldapConfig = ldapProvider.getLdapIdentityStore().getConfig();
            if (ldapConfig.getUsernameLdapAttribute().equals(ldapConfig.getRdnLdapAttribute())) {
                for (LDAPDn userDn : dns) {
                    String username = userDn.getFirstRdn().getAttrValue(ldapConfig.getRdnLdapAttribute());
                    usernames.add(username);
                }
            } else {
                LDAPQuery query = LDAPUtils.createQueryForUserSearch(ldapProvider, realm);
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                ArrayList<Condition> orSubconditions = new ArrayList<Condition>();
                for (LDAPDn userDn : dns) {
                    String firstRdnAttrValue = userDn.getFirstRdn().getAttrValue(ldapConfig.getRdnLdapAttribute());
                    if (firstRdnAttrValue == null) continue;
                    Condition condition = conditionsBuilder.equal(ldapConfig.getRdnLdapAttribute(), firstRdnAttrValue, EscapeStrategy.DEFAULT);
                    orSubconditions.add(condition);
                }
                Condition orCondition = conditionsBuilder.orCondition(orSubconditions.toArray(new Condition[0]));
                query.addWhereCondition(orCondition);
                List<LDAPObject> ldapUsers = query.getResultList();
                for (LDAPObject ldapUser : ldapUsers) {
                    if (!dns.contains(ldapUser.getDn())) continue;
                    String username = LDAPUtils.getUsername(ldapUser, ldapConfig);
                    usernames.add(username);
                }
            }
            return ldapProvider.loadUsersByUsernames(usernames, realm);
        }
    }
    ,
    UID{

        @Override
        public Set<LDAPDn> getLDAPSubgroups(CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup) {
            return Collections.emptySet();
        }

        @Override
        public List<UserModel> getGroupMembers(RealmModel realm, CommonLDAPGroupMapper groupMapper, LDAPObject ldapGroup, int firstResult, int maxResults) {
            List<String> usernames;
            LDAPStorageProvider ldapProvider = groupMapper.getLdapProvider();
            LDAPConfig ldapConfig = ldapProvider.getLdapIdentityStore().getConfig();
            String memberAttrName = groupMapper.getConfig().getMembershipLdapAttribute();
            Set<String> memberUids = LDAPUtils.getExistingMemberships(ldapProvider, memberAttrName, ldapGroup);
            if (memberUids == null || memberUids.size() <= firstResult) {
                return Collections.emptyList();
            }
            List<String> uids = new ArrayList<String>(memberUids);
            int max = Math.min(memberUids.size(), firstResult + maxResults);
            uids = uids.subList(firstResult, max);
            String membershipUserAttrName = groupMapper.getConfig().getMembershipUserLdapAttribute(ldapConfig);
            if (membershipUserAttrName.equals(ldapConfig.getUsernameLdapAttribute())) {
                usernames = uids;
            } else {
                usernames = new LinkedList();
                LDAPQuery query = LDAPUtils.createQueryForUserSearch(ldapProvider, realm);
                LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
                Condition[] orSubconditions = new Condition[uids.size()];
                int index = 0;
                for (String memberUid : uids) {
                    Condition condition;
                    orSubconditions[index] = condition = conditionsBuilder.equal(membershipUserAttrName, memberUid, EscapeStrategy.DEFAULT);
                    ++index;
                }
                Condition orCondition = conditionsBuilder.orCondition(orSubconditions);
                query.addWhereCondition(orCondition);
                List<LDAPObject> ldapUsers = query.getResultList();
                for (LDAPObject ldapUser : ldapUsers) {
                    String username = LDAPUtils.getUsername(ldapUser, ldapConfig);
                    usernames.add(username);
                }
            }
            return groupMapper.getLdapProvider().loadUsersByUsernames(usernames, realm);
        }
    };


    public abstract Set<LDAPDn> getLDAPSubgroups(CommonLDAPGroupMapper var1, LDAPObject var2);

    public abstract List<UserModel> getGroupMembers(RealmModel var1, CommonLDAPGroupMapper var2, LDAPObject var3, int var4, int var5);
}

