/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.component.ComponentModel;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.federation.kerberos.CommonKerberosConfig;
import org.keycloak.federation.kerberos.impl.KerberosServerSubjectAuthenticator;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakSessionTask;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.storage.UserStoragePrivateUtil;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderFactory;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.UserStorageUtil;
import org.keycloak.storage.ldap.LDAPConfig;
import org.keycloak.storage.ldap.LDAPIdentityStoreRegistry;
import org.keycloak.storage.ldap.LDAPStorageProvider;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.mappers.LDAPConfigDecorator;
import org.keycloak.storage.ldap.mappers.LDAPMappersComparator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.user.ImportSynchronization;
import org.keycloak.storage.user.SynchronizationResult;
import org.keycloak.utils.CredentialHelper;

public class LDAPStorageProviderFactory
implements UserStorageProviderFactory<LDAPStorageProvider>,
ImportSynchronization {
    private static final Logger logger = Logger.getLogger(LDAPStorageProviderFactory.class);
    public static final String PROVIDER_NAME = "ldap";
    private LDAPIdentityStoreRegistry ldapStoreRegistry;
    protected static final List<ProviderConfigProperty> configProperties = LDAPStorageProviderFactory.getConfigProps(null);

    private static List<ProviderConfigProperty> getConfigProps(ComponentModel parent) {
        boolean readOnly = false;
        if (parent != null) {
            LDAPConfig config = new LDAPConfig((MultivaluedHashMap<String, String>)parent.getConfig());
            readOnly = config.getEditMode() != UserStorageProvider.EditMode.WRITABLE;
        }
        return ProviderConfigurationBuilder.create().property().name("editMode").type("String").add().property().name("importEnabled").type("boolean").defaultValue((Object)"true").add().property().name("syncRegistrations").type("boolean").defaultValue((Object)"false").add().property().name("vendor").type("String").add().property().name("usePasswordModifyExtendedOp").type("boolean").add().property().name("usernameLDAPAttribute").type("String").add().property().name("rdnLDAPAttribute").type("String").add().property().name("uuidLDAPAttribute").type("String").add().property().name("userObjectClasses").type("String").add().property().name("connectionUrl").type("String").add().property().name("usersDn").type("String").add().property().name("authType").type("String").defaultValue((Object)"simple").add().property().name("startTls").type("boolean").add().property().name("bindDn").type("String").add().property().name("bindCredential").type("Password").secret(true).add().property().name("customUserSearchFilter").type("String").add().property().name("searchScope").type("String").defaultValue((Object)"1").add().property().name("validatePasswordPolicy").type("boolean").defaultValue((Object)"false").add().property().name("trustEmail").type("boolean").defaultValue((Object)"false").add().property().name("useTruststoreSpi").type("String").defaultValue((Object)"always").add().property().name("connectionPooling").type("boolean").defaultValue((Object)"true").add().property().name("connectionPoolingAuthentication").type("String").add().property().name("connectionPoolingDebug").type("String").add().property().name("connectionPoolingInitSize").type("String").add().property().name("connectionPoolingMaxSize").type("String").add().property().name("connectionPoolingPrefSize").type("String").add().property().name("connectionPoolingProtocol").type("String").add().property().name("connectionPoolingTimeout").type("String").add().property().name("connectionTimeout").type("String").add().property().name("readTimeout").type("String").add().property().name("pagination").type("boolean").defaultValue((Object)"true").add().property().name("allowKerberosAuthentication").type("boolean").defaultValue((Object)"false").add().property().name("serverPrincipal").type("String").add().property().name("keyTab").type("String").add().property().name("kerberosRealm").type("String").add().property().name("debug").type("boolean").defaultValue((Object)"false").add().property().name("useKerberosForPasswordAuthentication").type("boolean").defaultValue((Object)"false").add().build();
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public LDAPStorageProvider create(KeycloakSession session, ComponentModel model) {
        Map<ComponentModel, LDAPConfigDecorator> configDecorators = this.getLDAPConfigDecorators(session, model);
        LDAPIdentityStore ldapIdentityStore = this.ldapStoreRegistry.getLdapStore(session, model, configDecorators);
        return new LDAPStorageProvider(this, session, model, ldapIdentityStore);
    }

    protected Map<ComponentModel, LDAPConfigDecorator> getLDAPConfigDecorators(KeycloakSession session, ComponentModel ldapModel) {
        RealmModel realm = session.realms().getRealm(ldapModel.getParentId());
        return realm.getComponentsStream(ldapModel.getId(), LDAPStorageMapper.class.getName()).filter(mapperModel -> session.getKeycloakSessionFactory().getProviderFactory(LDAPStorageMapper.class, mapperModel.getProviderId()) instanceof LDAPConfigDecorator).collect(Collectors.toMap(Function.identity(), mapperModel -> (LDAPConfigDecorator)session.getKeycloakSessionFactory().getProviderFactory(LDAPStorageMapper.class, mapperModel.getProviderId())));
    }

    public void validateConfiguration(KeycloakSession session, RealmModel realm, ComponentModel config) throws ComponentValidationException {
        String readTimeout;
        LDAPConfig cfg = new LDAPConfig((MultivaluedHashMap<String, String>)config.getConfig());
        UserStorageProviderModel userStorageModel = new UserStorageProviderModel(config);
        String customFilter = cfg.getCustomUserSearchFilter();
        LDAPUtils.validateCustomLdapFilter(customFilter);
        String connectionTimeout = cfg.getConnectionTimeout();
        if (connectionTimeout != null && !connectionTimeout.isEmpty()) {
            try {
                Long.parseLong(connectionTimeout);
            }
            catch (NumberFormatException nfe) {
                throw new ComponentValidationException("ldapErrorConnectionTimeoutNotNumber", new Object[0]);
            }
        }
        if ((readTimeout = cfg.getReadTimeout()) != null && !readTimeout.isEmpty()) {
            try {
                Long.parseLong(readTimeout);
            }
            catch (NumberFormatException nfe) {
                throw new ComponentValidationException("ldapErrorReadTimeoutNotNumber", new Object[0]);
            }
        }
        if (cfg.isStartTls() && cfg.getConnectionPooling() != null) {
            throw new ComponentValidationException("ldapErrorCantEnableStartTlsAndConnectionPooling", new Object[0]);
        }
        if (config.get("editMode") == null) {
            throw new ComponentValidationException("ldapErrorEditModeMandatory", new Object[0]);
        }
        if (cfg.getEditMode() != UserStorageProvider.EditMode.WRITABLE && cfg.isValidatePasswordPolicy()) {
            throw new ComponentValidationException("ldapErrorValidatePasswordPolicyAvailableForWritableOnly", new Object[0]);
        }
        if (!userStorageModel.isImportEnabled() && cfg.getEditMode() == UserStorageProvider.EditMode.UNSYNCED) {
            throw new ComponentValidationException("ldapErrorCantEnableUnsyncedAndImportOff", new Object[0]);
        }
    }

    public void init(Config.Scope config) {
        this.ldapStoreRegistry = new LDAPIdentityStoreRegistry();
    }

    public void close() {
        this.ldapStoreRegistry = null;
    }

    public String getId() {
        return PROVIDER_NAME;
    }

    public void onCreate(KeycloakSession session, RealmModel realm, ComponentModel model) {
        String allowKerberosCfg;
        LDAPConfig ldapConfig = new LDAPConfig((MultivaluedHashMap<String, String>)model.getConfig());
        boolean activeDirectory = ldapConfig.isActiveDirectory();
        UserStorageProvider.EditMode editMode = ldapConfig.getEditMode();
        String readOnly = String.valueOf(editMode == UserStorageProvider.EditMode.READ_ONLY || editMode == UserStorageProvider.EditMode.UNSYNCED);
        String usernameLdapAttribute = ldapConfig.getUsernameLdapAttribute();
        boolean syncRegistrations = Boolean.valueOf((String)model.getConfig().getFirst((Object)"syncRegistrations"));
        String alwaysReadValueFromLDAP = String.valueOf(editMode == UserStorageProvider.EditMode.READ_ONLY || editMode == UserStorageProvider.EditMode.WRITABLE);
        ComponentModel mapperModel = KeycloakModelUtils.createComponentModel((String)"username", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "username", "ldap.attribute", usernameLdapAttribute, "read.only", readOnly, "always.read.value.from.ldap", "false", "is.mandatory.in.ldap", "true"});
        realm.addComponentModel(mapperModel);
        if (ldapConfig.getRdnLdapAttribute().equalsIgnoreCase("cn")) {
            if (usernameLdapAttribute.equalsIgnoreCase("cn")) {
                mapperModel = KeycloakModelUtils.createComponentModel((String)"first name", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "firstName", "ldap.attribute", "givenName", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
                realm.addComponentModel(mapperModel);
            } else if (editMode == UserStorageProvider.EditMode.WRITABLE) {
                mapperModel = KeycloakModelUtils.createComponentModel((String)"first name", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "firstName", "ldap.attribute", "givenName", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
                realm.addComponentModel(mapperModel);
                mapperModel = KeycloakModelUtils.createComponentModel((String)"username-cn", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "username", "ldap.attribute", "cn", "read.only", readOnly, "always.read.value.from.ldap", "false", "is.mandatory.in.ldap", "true"});
                realm.addComponentModel(mapperModel);
            } else {
                mapperModel = KeycloakModelUtils.createComponentModel((String)"full name", (String)model.getId(), (String)"full-name-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"ldap.full.name.attribute", "cn", "read.only", readOnly, "write.only", "false"});
                realm.addComponentModel(mapperModel);
            }
        } else {
            mapperModel = KeycloakModelUtils.createComponentModel((String)"first name", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "firstName", "ldap.attribute", "cn", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
            realm.addComponentModel(mapperModel);
        }
        mapperModel = KeycloakModelUtils.createComponentModel((String)"last name", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "lastName", "ldap.attribute", "sn", "read.only", readOnly, "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "true"});
        realm.addComponentModel(mapperModel);
        mapperModel = KeycloakModelUtils.createComponentModel((String)"email", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "email", "ldap.attribute", "mail", "read.only", readOnly, "always.read.value.from.ldap", "false", "is.mandatory.in.ldap", "false"});
        realm.addComponentModel(mapperModel);
        String createTimestampLdapAttrName = activeDirectory ? "whenCreated" : "createTimestamp";
        String modifyTimestampLdapAttrName = activeDirectory ? "whenChanged" : "modifyTimestamp";
        mapperModel = KeycloakModelUtils.createComponentModel((String)"creation date", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "createTimestamp", "ldap.attribute", createTimestampLdapAttrName, "read.only", "true", "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "false"});
        realm.addComponentModel(mapperModel);
        mapperModel = KeycloakModelUtils.createComponentModel((String)"modify date", (String)model.getId(), (String)"user-attribute-ldap-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"user.model.attribute", "modifyTimestamp", "ldap.attribute", modifyTimestampLdapAttrName, "read.only", "true", "always.read.value.from.ldap", alwaysReadValueFromLDAP, "is.mandatory.in.ldap", "false"});
        realm.addComponentModel(mapperModel);
        if (activeDirectory) {
            mapperModel = KeycloakModelUtils.createComponentModel((String)"MSAD account controls", (String)model.getId(), (String)"msad-user-account-control-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[0]);
            realm.addComponentModel(mapperModel);
        }
        if (Boolean.valueOf(allowKerberosCfg = (String)model.getConfig().getFirst((Object)"allowKerberosAuthentication")).booleanValue()) {
            CredentialHelper.setOrReplaceAuthenticationRequirement((KeycloakSession)session, (RealmModel)realm, (String)"kerberos", (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.ALTERNATIVE, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.DISABLED);
        }
        if (!activeDirectory && syncRegistrations && ldapConfig.useExtendedPasswordModifyOp()) {
            mapperModel = KeycloakModelUtils.createComponentModel((String)"random initial password", (String)model.getId(), (String)"hardcoded-ldap-attribute-mapper", (String)LDAPStorageMapper.class.getName(), (String[])new String[]{"ldap.attribute.name", "userpassword", "ldap.attribute.value", "${RANDOM}"});
            realm.addComponentModel(mapperModel);
        }
    }

    public void onUpdate(KeycloakSession session, RealmModel realm, ComponentModel oldModel, ComponentModel newModel) {
        boolean allowKerberosCfgOld = Boolean.valueOf((String)oldModel.getConfig().getFirst((Object)"allowKerberosAuthentication"));
        boolean allowKerberosCfgNew = Boolean.valueOf((String)newModel.getConfig().getFirst((Object)"allowKerberosAuthentication"));
        if (!allowKerberosCfgOld && allowKerberosCfgNew) {
            CredentialHelper.setOrReplaceAuthenticationRequirement((KeycloakSession)session, (RealmModel)realm, (String)"kerberos", (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.ALTERNATIVE, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.DISABLED);
        } else if (allowKerberosCfgOld && !allowKerberosCfgNew) {
            CredentialHelper.setOrReplaceAuthenticationRequirement((KeycloakSession)session, (RealmModel)realm, (String)"kerberos", (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.DISABLED, (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.ALTERNATIVE);
        }
    }

    public void preRemove(KeycloakSession session, RealmModel realm, ComponentModel model) {
        String allowKerberosCfg = (String)model.getConfig().getFirst((Object)"allowKerberosAuthentication");
        if (Boolean.valueOf(allowKerberosCfg).booleanValue()) {
            CredentialHelper.setOrReplaceAuthenticationRequirement((KeycloakSession)session, (RealmModel)realm, (String)"kerberos", (AuthenticationExecutionModel.Requirement)AuthenticationExecutionModel.Requirement.DISABLED, null);
        }
    }

    public SynchronizationResult sync(KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        this.syncMappers(sessionFactory, realmId, (ComponentModel)model);
        logger.infof("Sync all users from LDAP to local store: realm: %s, federation provider: %s", (Object)realmId, (Object)model.getName());
        try (LDAPQuery userQuery = this.createQuery(sessionFactory, realmId, (ComponentModel)model);){
            SynchronizationResult syncResult = this.syncImpl(sessionFactory, userQuery, realmId, (ComponentModel)model);
            logger.infof("Sync all users finished: %s", (Object)syncResult.getStatus());
            SynchronizationResult synchronizationResult = syncResult;
            return synchronizationResult;
        }
    }

    public SynchronizationResult syncSince(Date lastSync, KeycloakSessionFactory sessionFactory, String realmId, UserStorageProviderModel model) {
        this.syncMappers(sessionFactory, realmId, (ComponentModel)model);
        logger.infof("Sync changed users from LDAP to local store: realm: %s, federation provider: %s, last sync time: " + lastSync, (Object)realmId, (Object)model.getName());
        LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
        Condition createCondition = conditionsBuilder.greaterThanOrEqualTo("createTimestamp", lastSync);
        Condition modifyCondition = conditionsBuilder.greaterThanOrEqualTo("modifyTimestamp", lastSync);
        Condition orCondition = conditionsBuilder.orCondition(createCondition, modifyCondition);
        try (LDAPQuery userQuery = this.createQuery(sessionFactory, realmId, (ComponentModel)model);){
            userQuery.addWhereCondition(orCondition);
            SynchronizationResult result = this.syncImpl(sessionFactory, userQuery, realmId, (ComponentModel)model);
            logger.infof("Sync changed users finished: %s", (Object)result.getStatus());
            SynchronizationResult synchronizationResult = result;
            return synchronizationResult;
        }
    }

    protected void syncMappers(KeycloakSessionFactory sessionFactory, final String realmId, final ComponentModel model) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

            public void run(KeycloakSession session) {
                RealmModel realm = session.realms().getRealm(realmId);
                session.getContext().setRealm(realm);
                session.getProvider(UserStorageProvider.class, model);
                realm.getComponentsStream(model.getId(), LDAPStorageMapper.class.getName()).forEach(mapperModel -> {
                    SynchronizationResult syncResult = ((LDAPStorageMapper)session.getProvider(LDAPStorageMapper.class, mapperModel)).syncDataFromFederationProviderToKeycloak(realm);
                    if (syncResult.getAdded() > 0 || syncResult.getUpdated() > 0 || syncResult.getRemoved() > 0 || syncResult.getFailed() > 0) {
                        logger.infof("Sync of federation mapper '%s' finished. Status: %s", (Object)mapperModel.getName(), (Object)syncResult.toString());
                    }
                });
            }
        });
    }

    protected SynchronizationResult syncImpl(KeycloakSessionFactory sessionFactory, LDAPQuery userQuery, String realmId, ComponentModel fedModel) {
        SynchronizationResult syncResult = new SynchronizationResult();
        LDAPConfig ldapConfig = new LDAPConfig((MultivaluedHashMap<String, String>)fedModel.getConfig());
        boolean pagination = ldapConfig.isPagination();
        if (pagination) {
            int pageSize = ldapConfig.getBatchSizeForSync();
            boolean nextPage = true;
            while (nextPage) {
                userQuery.setLimit(pageSize);
                List<LDAPObject> users = userQuery.getResultList();
                nextPage = userQuery.getPaginationContext().hasNextPage();
                SynchronizationResult currentPageSync = this.importLdapUsers(sessionFactory, realmId, fedModel, users);
                syncResult.add(currentPageSync);
            }
        } else {
            List<LDAPObject> users = userQuery.getResultList();
            SynchronizationResult currentSync = this.importLdapUsers(sessionFactory, realmId, fedModel, users);
            syncResult.add(currentSync);
        }
        return syncResult;
    }

    private LDAPQuery createQuery(KeycloakSessionFactory sessionFactory, final String realmId, final ComponentModel model) {
        class QueryHolder {
            LDAPQuery query;

            QueryHolder() {
            }
        }
        final QueryHolder queryHolder = new QueryHolder();
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){
            {
            }

            public void run(KeycloakSession session) {
                session.getContext().setRealm(session.realms().getRealm(realmId));
                LDAPStorageProvider ldapFedProvider = (LDAPStorageProvider)session.getProvider(UserStorageProvider.class, model);
                RealmModel realm = session.realms().getRealm(realmId);
                queryHolder.query = LDAPUtils.createQueryForUserSearch(ldapFedProvider, realm);
            }
        });
        return queryHolder.query;
    }

    protected SynchronizationResult importLdapUsers(KeycloakSessionFactory sessionFactory, final String realmId, final ComponentModel fedModel, List<LDAPObject> ldapUsers) {
        final SynchronizationResult syncResult = new SynchronizationResult();
        class BooleanHolder {
            private boolean value = true;

            BooleanHolder() {
            }
        }
        final BooleanHolder exists = new BooleanHolder();
        for (final LDAPObject ldapUser : ldapUsers) {
            try {
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){
                    {
                    }

                    public void run(KeycloakSession session) {
                        LDAPStorageProvider ldapFedProvider = (LDAPStorageProvider)session.getProvider(UserStorageProvider.class, fedModel);
                        RealmModel currentRealm = session.realms().getRealm(realmId);
                        session.getContext().setRealm(currentRealm);
                        String username = LDAPUtils.getUsername(ldapUser, ldapFedProvider.getLdapIdentityStore().getConfig());
                        exists.value = true;
                        LDAPUtils.checkUuid(ldapUser, ldapFedProvider.getLdapIdentityStore().getConfig());
                        UserModel currentUserLocal = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).getUserByUsername(currentRealm, username);
                        Optional userModelOptional = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).searchForUserByUserAttributeStream(currentRealm, "LDAP_ID", ldapUser.getUuid()).findFirst();
                        if (!userModelOptional.isPresent() && currentUserLocal == null) {
                            exists.value = false;
                            ldapFedProvider.importUserFromLDAP(session, currentRealm, ldapUser);
                            syncResult.increaseAdded();
                        } else {
                            UserModel currentUser;
                            UserModel userModel = currentUser = userModelOptional.isPresent() ? (UserModel)userModelOptional.get() : currentUserLocal;
                            if (fedModel.getId().equals(currentUser.getFederationLink()) && ldapUser.getUuid().equals(currentUser.getFirstAttribute("LDAP_ID"))) {
                                LDAPMappersComparator ldapMappersComparator = new LDAPMappersComparator(ldapFedProvider.getLdapIdentityStore().getConfig());
                                currentRealm.getComponentsStream(fedModel.getId(), LDAPStorageMapper.class.getName()).sorted(ldapMappersComparator.sortDesc()).forEachOrdered(mapperModel -> {
                                    LDAPStorageMapper ldapMapper = ldapFedProvider.getMapperManager().getMapper((ComponentModel)mapperModel);
                                    ldapMapper.onImportUserFromLDAP(ldapUser, currentUser, currentRealm, false);
                                });
                                UserCache userCache = UserStorageUtil.userCache((KeycloakSession)session);
                                if (userCache != null) {
                                    userCache.evict(currentRealm, currentUser);
                                }
                                logger.debugf("Updated user from LDAP: %s", (Object)currentUser.getUsername());
                                syncResult.increaseUpdated();
                            } else {
                                logger.warnf("User with ID '%s' is not updated during sync as he already exists in Keycloak database but is not linked to federation provider '%s'", (Object)ldapUser.getUuid(), (Object)fedModel.getName());
                                syncResult.increaseFailed();
                            }
                        }
                    }
                });
            }
            catch (ModelException me) {
                logger.error((Object)"Failed during import user from LDAP", (Throwable)me);
                syncResult.increaseFailed();
                if (exists.value) continue;
                KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)sessionFactory, (KeycloakSessionTask)new KeycloakSessionTask(){

                    public void run(KeycloakSession session) {
                        UserModel existing;
                        LDAPStorageProvider ldapFedProvider = (LDAPStorageProvider)session.getProvider(UserStorageProvider.class, fedModel);
                        RealmModel currentRealm = session.realms().getRealm(realmId);
                        session.getContext().setRealm(currentRealm);
                        String username = null;
                        try {
                            username = LDAPUtils.getUsername(ldapUser, ldapFedProvider.getLdapIdentityStore().getConfig());
                        }
                        catch (ModelException modelException) {
                            // empty catch block
                        }
                        if (username != null && (existing = UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).getUserByUsername(currentRealm, username)) != null) {
                            UserCache userCache = UserStorageUtil.userCache((KeycloakSession)session);
                            if (userCache != null) {
                                userCache.evict(currentRealm, existing);
                            }
                            UserStoragePrivateUtil.userLocalStorage((KeycloakSession)session).removeUser(currentRealm, existing);
                        }
                    }
                });
            }
        }
        return syncResult;
    }

    protected SPNEGOAuthenticator createSPNEGOAuthenticator(String spnegoToken, CommonKerberosConfig kerberosConfig) {
        KerberosServerSubjectAuthenticator kerberosAuth = this.createKerberosSubjectAuthenticator(kerberosConfig);
        return new SPNEGOAuthenticator(kerberosConfig, kerberosAuth, spnegoToken);
    }

    protected KerberosServerSubjectAuthenticator createKerberosSubjectAuthenticator(CommonKerberosConfig kerberosConfig) {
        return new KerberosServerSubjectAuthenticator(kerberosConfig);
    }

    protected KerberosUsernamePasswordAuthenticator createKerberosUsernamePasswordAuthenticator(CommonKerberosConfig kerberosConfig) {
        return new KerberosUsernamePasswordAuthenticator(kerberosConfig);
    }
}

