/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.ldap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import org.jboss.logging.Logger;
import org.keycloak.component.ComponentModel;
import org.keycloak.credential.CredentialAuthentication;
import org.keycloak.credential.CredentialInput;
import org.keycloak.credential.CredentialInputUpdater;
import org.keycloak.credential.CredentialInputValidator;
import org.keycloak.federation.kerberos.impl.KerberosUsernamePasswordAuthenticator;
import org.keycloak.federation.kerberos.impl.SPNEGOAuthenticator;
import org.keycloak.models.CredentialValidationOutput;
import org.keycloak.models.GroupModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.ModelException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredActionProviderModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserManager;
import org.keycloak.models.UserModel;
import org.keycloak.models.cache.CachedUserModel;
import org.keycloak.models.cache.UserCache;
import org.keycloak.models.utils.DefaultRoles;
import org.keycloak.models.utils.ReadOnlyUserModelDelegate;
import org.keycloak.policy.PasswordPolicyManagerProvider;
import org.keycloak.policy.PolicyError;
import org.keycloak.storage.ReadOnlyException;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.UserStorageProvider;
import org.keycloak.storage.UserStorageProviderModel;
import org.keycloak.storage.adapter.InMemoryUserAdapter;
import org.keycloak.storage.ldap.LDAPStorageProviderFactory;
import org.keycloak.storage.ldap.LDAPStorageUserManager;
import org.keycloak.storage.ldap.LDAPUtils;
import org.keycloak.storage.ldap.ReadonlyLDAPUserModelDelegate;
import org.keycloak.storage.ldap.UnsyncedLDAPUserModelDelegate;
import org.keycloak.storage.ldap.WritableLDAPUserModelDelegate;
import org.keycloak.storage.ldap.idm.model.LDAPObject;
import org.keycloak.storage.ldap.idm.query.Condition;
import org.keycloak.storage.ldap.idm.query.EscapeStrategy;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQuery;
import org.keycloak.storage.ldap.idm.query.internal.LDAPQueryConditionsBuilder;
import org.keycloak.storage.ldap.idm.store.ldap.LDAPIdentityStore;
import org.keycloak.storage.ldap.kerberos.LDAPProviderKerberosConfig;
import org.keycloak.storage.ldap.mappers.LDAPOperationDecorator;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapper;
import org.keycloak.storage.ldap.mappers.LDAPStorageMapperManager;
import org.keycloak.storage.ldap.mappers.PasswordUpdateCallback;
import org.keycloak.storage.user.ImportedUserValidation;
import org.keycloak.storage.user.UserLookupProvider;
import org.keycloak.storage.user.UserQueryProvider;
import org.keycloak.storage.user.UserRegistrationProvider;

public class LDAPStorageProvider
implements UserStorageProvider,
CredentialInputValidator,
CredentialInputUpdater,
CredentialAuthentication,
UserLookupProvider,
UserRegistrationProvider,
UserQueryProvider,
ImportedUserValidation {
    private static final Logger logger = Logger.getLogger(LDAPStorageProvider.class);
    protected LDAPStorageProviderFactory factory;
    protected KeycloakSession session;
    protected UserStorageProviderModel model;
    protected LDAPIdentityStore ldapIdentityStore;
    protected UserStorageProvider.EditMode editMode;
    protected LDAPProviderKerberosConfig kerberosConfig;
    protected PasswordUpdateCallback updater;
    protected LDAPStorageMapperManager mapperManager;
    protected LDAPStorageUserManager userManager;
    protected final Set<String> supportedCredentialTypes = new HashSet<String>();

    public LDAPStorageProvider(LDAPStorageProviderFactory factory, KeycloakSession session, ComponentModel model, LDAPIdentityStore ldapIdentityStore) {
        this.factory = factory;
        this.session = session;
        this.model = new UserStorageProviderModel(model);
        this.ldapIdentityStore = ldapIdentityStore;
        this.kerberosConfig = new LDAPProviderKerberosConfig(model);
        this.editMode = ldapIdentityStore.getConfig().getEditMode();
        this.mapperManager = new LDAPStorageMapperManager(this);
        this.userManager = new LDAPStorageUserManager(this);
        this.supportedCredentialTypes.add("password");
        if (this.kerberosConfig.isAllowKerberosAuthentication()) {
            this.supportedCredentialTypes.add("kerberos");
        }
    }

    public void setUpdater(PasswordUpdateCallback updater) {
        this.updater = updater;
    }

    public KeycloakSession getSession() {
        return this.session;
    }

    public LDAPIdentityStore getLdapIdentityStore() {
        return this.ldapIdentityStore;
    }

    public UserStorageProvider.EditMode getEditMode() {
        return this.editMode;
    }

    public UserStorageProviderModel getModel() {
        return this.model;
    }

    public LDAPStorageMapperManager getMapperManager() {
        return this.mapperManager;
    }

    public LDAPStorageUserManager getUserManager() {
        return this.userManager;
    }

    public UserModel validate(RealmModel realm, UserModel local) {
        LDAPObject ldapObject = this.loadAndValidateUser(realm, local);
        if (ldapObject == null) {
            return null;
        }
        return this.proxy(realm, local, ldapObject);
    }

    protected UserModel proxy(RealmModel realm, UserModel local, LDAPObject ldapObject) {
        UserModel existing = this.userManager.getManagedProxiedUser(local.getId());
        if (existing != null) {
            return existing;
        }
        if (local instanceof CachedUserModel && (existing = this.userManager.getManagedProxiedUser((local = this.session.userStorageManager().getUserById(local.getId(), realm)).getId())) != null) {
            return existing;
        }
        UserModel proxied = local;
        this.checkDNChanged(realm, local, ldapObject);
        switch (this.editMode) {
            case READ_ONLY: {
                if (this.model.isImportEnabled()) {
                    proxied = new ReadonlyLDAPUserModelDelegate(local, this);
                    break;
                }
                proxied = new ReadOnlyUserModelDelegate(local);
                break;
            }
            case WRITABLE: {
                proxied = new WritableLDAPUserModelDelegate(local, this, ldapObject);
                break;
            }
            case UNSYNCED: {
                proxied = new UnsyncedLDAPUserModelDelegate(local, this);
            }
        }
        List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
        List<ComponentModel> sortedMappers = this.mapperManager.sortMappersAsc(mappers);
        for (ComponentModel mapperModel : sortedMappers) {
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper(mapperModel);
            proxied = ldapMapper.proxy(ldapObject, proxied, realm);
        }
        this.userManager.setManagedProxiedUser(proxied, ldapObject);
        return proxied;
    }

    private void checkDNChanged(RealmModel realm, UserModel local, LDAPObject ldapObject) {
        String dnFromDB = local.getFirstAttribute("LDAP_ENTRY_DN");
        String ldapDn = ldapObject.getDn().toString();
        if (!ldapDn.equals(dnFromDB)) {
            logger.debugf("Updated LDAP DN of user '%s' to '%s'", (Object)local.getUsername(), (Object)ldapDn);
            local.setSingleAttribute("LDAP_ENTRY_DN", ldapDn);
            UserCache userCache = this.session.userCache();
            if (userCache != null) {
                userCache.evict(realm, local);
            }
        }
    }

    public boolean supportsCredentialAuthenticationFor(String type) {
        return type.equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication();
    }

    public List<UserModel> searchForUserByUserAttribute(String attrName, String attrValue, RealmModel realm) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition attrCondition = conditionsBuilder.equal(attrName, attrValue, EscapeStrategy.DEFAULT);
            ldapQuery.addWhereCondition(attrCondition);
            List<LDAPObject> ldapObjects = ldapQuery.getResultList();
            if (ldapObjects == null || ldapObjects.isEmpty()) {
                List<UserModel> list = Collections.emptyList();
                return list;
            }
            LinkedList<UserModel> searchResults = new LinkedList<UserModel>();
            for (LDAPObject ldapUser : ldapObjects) {
                String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
                if (this.session.userLocalStorage().getUserByUsername(ldapUsername, realm) != null) continue;
                UserModel imported = this.importUserFromLDAP(this.session, realm, ldapUser);
                searchResults.add(imported);
            }
            LinkedList<UserModel> linkedList = searchResults;
            return linkedList;
        }
    }

    public boolean synchronizeRegistrations() {
        return "true".equalsIgnoreCase((String)this.model.getConfig().getFirst((Object)"syncRegistrations")) && this.editMode == UserStorageProvider.EditMode.WRITABLE;
    }

    public UserModel addUser(RealmModel realm, String username) {
        if (!this.synchronizeRegistrations()) {
            return null;
        }
        UserModel user = null;
        if (this.model.isImportEnabled()) {
            user = this.session.userLocalStorage().addUser(realm, username);
            user.setFederationLink(this.model.getId());
        } else {
            user = new InMemoryUserAdapter(this.session, realm, new StorageId(this.model.getId(), username).getId());
            user.setUsername(username);
        }
        LDAPObject ldapUser = LDAPUtils.addUserToLDAP(this, realm, user);
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        user.setSingleAttribute("LDAP_ID", ldapUser.getUuid());
        user.setSingleAttribute("LDAP_ENTRY_DN", ldapUser.getDn().toString());
        UserModel proxy = this.proxy(realm, user, ldapUser);
        DefaultRoles.addDefaultRoles((RealmModel)realm, (UserModel)proxy);
        for (GroupModel g : realm.getDefaultGroups()) {
            proxy.joinGroup(g);
        }
        for (RequiredActionProviderModel r : realm.getRequiredActionProviders()) {
            if (!r.isEnabled() || !r.isDefaultAction()) continue;
            proxy.addRequiredAction(r.getAlias());
        }
        return proxy;
    }

    public boolean removeUser(RealmModel realm, UserModel user) {
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY || this.editMode == UserStorageProvider.EditMode.UNSYNCED) {
            logger.warnf("User '%s' can't be deleted in LDAP as editMode is '%s'. Deleting user just from Keycloak DB, but he will be re-imported from LDAP again once searched in Keycloak", (Object)user.getUsername(), (Object)this.editMode.toString());
            return true;
        }
        LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
        if (ldapObject == null) {
            logger.warnf("User '%s' can't be deleted from LDAP as it doesn't exist here", (Object)user.getUsername());
            return false;
        }
        this.ldapIdentityStore.remove(ldapObject);
        this.userManager.removeManagedUserEntry(user.getId());
        return true;
    }

    public UserModel getUserById(String id, RealmModel realm) {
        UserModel alreadyLoadedInSession = this.userManager.getManagedProxiedUser(id);
        if (alreadyLoadedInSession != null) {
            return alreadyLoadedInSession;
        }
        StorageId storageId = new StorageId(id);
        return this.getUserByUsername(storageId.getExternalId(), realm);
    }

    public int getUsersCount(RealmModel realm) {
        return 0;
    }

    public List<UserModel> getUsers(RealmModel realm) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> getUsers(RealmModel realm, int firstResult, int maxResults) {
        return Collections.EMPTY_LIST;
    }

    public List<UserModel> searchForUser(String search, RealmModel realm) {
        return this.searchForUser(search, realm, 0, 0x7FFFFFFE);
    }

    public List<UserModel> searchForUser(String search, RealmModel realm, int firstResult, int maxResults) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        int spaceIndex = search.lastIndexOf(32);
        if (spaceIndex > -1) {
            String firstName = search.substring(0, spaceIndex).trim();
            String lastName = search.substring(spaceIndex).trim();
            attributes.put("firstName", firstName);
            attributes.put("lastName", lastName);
        } else if (search.indexOf(64) > -1) {
            attributes.put("username", search.trim().toLowerCase());
            attributes.put("email", search.trim().toLowerCase());
        } else {
            attributes.put("lastName", search.trim());
            attributes.put("username", search.trim().toLowerCase());
        }
        return this.searchForUser(attributes, realm, firstResult, maxResults);
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm) {
        return this.searchForUser(params, realm, 0, 0x7FFFFFFE);
    }

    public List<UserModel> searchForUser(Map<String, String> params, RealmModel realm, int firstResult, int maxResults) {
        LinkedList<UserModel> searchResults = new LinkedList<UserModel>();
        List<LDAPObject> ldapUsers = this.searchLDAP(realm, params, maxResults + firstResult);
        int counter = 0;
        for (LDAPObject ldapUser : ldapUsers) {
            if (counter++ < firstResult) continue;
            String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
            if (this.session.userLocalStorage().getUserByUsername(ldapUsername, realm) != null) continue;
            UserModel imported = this.importUserFromLDAP(this.session, realm, ldapUser);
            searchResults.add(imported);
        }
        return searchResults;
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group) {
        return this.getGroupMembers(realm, group, 0, 0x7FFFFFFE);
    }

    public List<UserModel> getGroupMembers(RealmModel realm, GroupModel group, int firstResult, int maxResults) {
        List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
        List<ComponentModel> sortedMappers = this.mapperManager.sortMappersAsc(mappers);
        for (ComponentModel mapperModel : sortedMappers) {
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper(mapperModel);
            List<UserModel> users = ldapMapper.getGroupMembers(realm, group, firstResult, maxResults);
            if (users.size() <= 0) continue;
            return users;
        }
        return Collections.emptyList();
    }

    public List<UserModel> loadUsersByUsernames(List<String> usernames, RealmModel realm) {
        ArrayList<UserModel> result = new ArrayList<UserModel>();
        for (String username : usernames) {
            UserModel kcUser = this.session.users().getUserByUsername(username, realm);
            if (kcUser == null) {
                logger.warnf("User '%s' referenced by membership wasn't found in LDAP", (Object)username);
                continue;
            }
            if (this.model.isImportEnabled() && !this.model.getId().equals(kcUser.getFederationLink())) {
                logger.warnf("Incorrect federation provider of user '%s'", (Object)kcUser.getUsername());
                continue;
            }
            result.add(kcUser);
        }
        return result;
    }

    protected List<LDAPObject> searchLDAP(RealmModel realm, Map<String, String> attributes, int maxResults) {
        List<LDAPObject> ldapObjects;
        LDAPQueryConditionsBuilder conditionsBuilder2;
        Throwable throwable;
        LDAPQuery ldapQuery;
        ArrayList<LDAPObject> results = new ArrayList<LDAPObject>();
        if (attributes.containsKey("username")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            throwable = null;
            try {
                conditionsBuilder2 = new LDAPQueryConditionsBuilder();
                Condition usernameCondition = conditionsBuilder2.equal("username", attributes.get("username"), EscapeStrategy.NON_ASCII_CHARS_ONLY);
                ldapQuery.addWhereCondition(usernameCondition);
                ldapObjects = ldapQuery.getResultList();
                results.addAll(ldapObjects);
            }
            catch (Throwable conditionsBuilder2) {
                throwable = conditionsBuilder2;
                throw conditionsBuilder2;
            }
            finally {
                if (ldapQuery != null) {
                    if (throwable != null) {
                        try {
                            ldapQuery.close();
                        }
                        catch (Throwable conditionsBuilder2) {
                            throwable.addSuppressed(conditionsBuilder2);
                        }
                    } else {
                        ldapQuery.close();
                    }
                }
            }
        }
        if (attributes.containsKey("email")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            throwable = null;
            try {
                conditionsBuilder2 = new LDAPQueryConditionsBuilder();
                Condition emailCondition = conditionsBuilder2.equal("email", attributes.get("email"), EscapeStrategy.NON_ASCII_CHARS_ONLY);
                ldapQuery.addWhereCondition(emailCondition);
                ldapObjects = ldapQuery.getResultList();
                results.addAll(ldapObjects);
            }
            catch (Throwable conditionsBuilder3) {
                throwable = conditionsBuilder3;
                throw conditionsBuilder3;
            }
            finally {
                if (ldapQuery != null) {
                    if (throwable != null) {
                        try {
                            ldapQuery.close();
                        }
                        catch (Throwable conditionsBuilder3) {
                            throwable.addSuppressed(conditionsBuilder3);
                        }
                    } else {
                        ldapQuery.close();
                    }
                }
            }
        }
        if (attributes.containsKey("firstName") || attributes.containsKey("lastName")) {
            ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);
            throwable = null;
            try {
                conditionsBuilder2 = new LDAPQueryConditionsBuilder();
                if (attributes.containsKey("firstName")) {
                    ldapQuery.addWhereCondition(conditionsBuilder2.equal("firstName", attributes.get("firstName"), EscapeStrategy.NON_ASCII_CHARS_ONLY));
                }
                if (attributes.containsKey("lastName")) {
                    ldapQuery.addWhereCondition(conditionsBuilder2.equal("lastName", attributes.get("lastName"), EscapeStrategy.NON_ASCII_CHARS_ONLY));
                }
                List<LDAPObject> ldapObjects2 = ldapQuery.getResultList();
                results.addAll(ldapObjects2);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ldapQuery != null) {
                    if (throwable != null) {
                        try {
                            ldapQuery.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ldapQuery.close();
                    }
                }
            }
        }
        return results;
    }

    protected LDAPObject loadAndValidateUser(RealmModel realm, UserModel local) {
        LDAPObject existing = this.userManager.getManagedLDAPUser(local.getId());
        if (existing != null) {
            return existing;
        }
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, local.getUsername());
        if (ldapUser == null) {
            return null;
        }
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        if (ldapUser.getUuid().equals(local.getFirstAttribute("LDAP_ID"))) {
            return ldapUser;
        }
        logger.warnf("LDAP User invalid. ID doesn't match. ID from LDAP [%s], LDAP ID from local DB: [%s]", (Object)ldapUser.getUuid(), (Object)local.getFirstAttribute("LDAP_ID"));
        return null;
    }

    public UserModel getUserByUsername(String username, RealmModel realm) {
        LDAPObject ldapUser = this.loadLDAPUserByUsername(realm, username);
        if (ldapUser == null) {
            return null;
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    protected UserModel importUserFromLDAP(KeycloakSession session, RealmModel realm, LDAPObject ldapUser) {
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel imported = null;
        if (this.model.isImportEnabled()) {
            imported = session.userLocalStorage().addUser(realm, ldapUsername);
        } else {
            InMemoryUserAdapter adapter = new InMemoryUserAdapter(session, realm, new StorageId(this.model.getId(), ldapUsername).getId());
            adapter.addDefaults();
            imported = adapter;
        }
        imported.setEnabled(true);
        List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
        List<ComponentModel> sortedMappers = this.mapperManager.sortMappersDesc(mappers);
        for (ComponentModel mapperModel : sortedMappers) {
            if (logger.isTraceEnabled()) {
                logger.tracef("Using mapper %s during import user from LDAP", (Object)mapperModel);
            }
            LDAPStorageMapper ldapMapper = this.mapperManager.getMapper(mapperModel);
            ldapMapper.onImportUserFromLDAP(ldapUser, imported, realm, true);
        }
        String userDN = ldapUser.getDn().toString();
        if (this.model.isImportEnabled()) {
            imported.setFederationLink(this.model.getId());
        }
        imported.setSingleAttribute("LDAP_ID", ldapUser.getUuid());
        imported.setSingleAttribute("LDAP_ENTRY_DN", userDN);
        if (this.getLdapIdentityStore().getConfig().isTrustEmail()) {
            imported.setEmailVerified(true);
        }
        logger.debugf("Imported new user from LDAP to Keycloak DB. Username: [%s], Email: [%s], LDAP_ID: [%s], LDAP Entry DN: [%s]", new Object[]{imported.getUsername(), imported.getEmail(), ldapUser.getUuid(), userDN});
        UserModel proxy = this.proxy(realm, imported, ldapUser);
        return proxy;
    }

    protected LDAPObject queryByEmail(RealmModel realm, String email) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            Condition emailCondition = conditionsBuilder.equal("email", email, EscapeStrategy.DEFAULT);
            ldapQuery.addWhereCondition(emailCondition);
            LDAPObject lDAPObject = ldapQuery.getFirstResult();
            return lDAPObject;
        }
    }

    public UserModel getUserByEmail(String email, RealmModel realm) {
        LDAPObject ldapUser = this.queryByEmail(realm, email);
        if (ldapUser == null) {
            return null;
        }
        String ldapUsername = LDAPUtils.getUsername(ldapUser, this.ldapIdentityStore.getConfig());
        UserModel user = this.session.userLocalStorage().getUserByUsername(ldapUsername, realm);
        if (user != null) {
            LDAPUtils.checkUuid(ldapUser, this.ldapIdentityStore.getConfig());
            if (ldapUser.getUuid().equals(user.getFirstAttribute("LDAP_ID"))) {
                return user;
            }
            throw new ModelDuplicateException("User with username '" + ldapUsername + "' already exists in Keycloak. It conflicts with LDAP user with email '" + email + "'");
        }
        return this.importUserFromLDAP(this.session, realm, ldapUser);
    }

    public void preRemove(RealmModel realm) {
    }

    public void preRemove(RealmModel realm, RoleModel role) {
    }

    public void preRemove(RealmModel realm, GroupModel group) {
    }

    public boolean validPassword(RealmModel realm, UserModel user, String password) {
        if (this.kerberosConfig.isAllowKerberosAuthentication() && this.kerberosConfig.isUseKerberosForPasswordAuthentication()) {
            KerberosUsernamePasswordAuthenticator authenticator = this.factory.createKerberosUsernamePasswordAuthenticator(this.kerberosConfig);
            return authenticator.validUser(user.getUsername(), password);
        }
        LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
        try {
            this.ldapIdentityStore.validatePassword(ldapUser, password);
            return true;
        }
        catch (AuthenticationException ae) {
            boolean processed = false;
            List mappers = realm.getComponents(this.model.getId(), LDAPStorageMapper.class.getName());
            List<ComponentModel> sortedMappers = this.mapperManager.sortMappersDesc(mappers);
            for (ComponentModel mapperModel : sortedMappers) {
                if (logger.isTraceEnabled()) {
                    logger.tracef("Using mapper %s during import user from LDAP", (Object)mapperModel);
                }
                LDAPStorageMapper ldapMapper = this.mapperManager.getMapper(mapperModel);
                processed = processed || ldapMapper.onAuthenticationFailure(ldapUser, user, ae, realm);
            }
            return processed;
        }
    }

    public boolean updateCredential(RealmModel realm, UserModel user, CredentialInput input) {
        if (!"password".equals(input.getType()) || !(input instanceof UserCredentialModel)) {
            return false;
        }
        if (this.editMode == UserStorageProvider.EditMode.READ_ONLY) {
            throw new ReadOnlyException("Federated storage is not writable");
        }
        if (this.editMode == UserStorageProvider.EditMode.WRITABLE) {
            PolicyError error;
            LDAPIdentityStore ldapIdentityStore = this.getLdapIdentityStore();
            String password = input.getChallengeResponse();
            LDAPObject ldapUser = this.loadAndValidateUser(realm, user);
            if (ldapIdentityStore.getConfig().isValidatePasswordPolicy() && (error = ((PasswordPolicyManagerProvider)this.session.getProvider(PasswordPolicyManagerProvider.class)).validate(realm, user, password)) != null) {
                throw new ModelException(error.getMessage(), error.getParameters());
            }
            try {
                LDAPOperationDecorator operationDecorator = null;
                if (this.updater != null) {
                    operationDecorator = this.updater.beforePasswordUpdate(user, ldapUser, (UserCredentialModel)input);
                }
                ldapIdentityStore.updatePassword(ldapUser, password, operationDecorator);
                if (this.updater != null) {
                    this.updater.passwordUpdated(user, ldapUser, (UserCredentialModel)input);
                }
                return true;
            }
            catch (ModelException me) {
                if (this.updater != null) {
                    this.updater.passwordUpdateFailed(user, ldapUser, (UserCredentialModel)input, me);
                    return false;
                }
                throw me;
            }
        }
        return false;
    }

    public void disableCredentialType(RealmModel realm, UserModel user, String credentialType) {
    }

    public Set<String> getDisableableCredentialTypes(RealmModel realm, UserModel user) {
        return Collections.EMPTY_SET;
    }

    public Set<String> getSupportedCredentialTypes() {
        return new HashSet<String>(this.supportedCredentialTypes);
    }

    public boolean supportsCredentialType(String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isConfiguredFor(RealmModel realm, UserModel user, String credentialType) {
        return this.getSupportedCredentialTypes().contains(credentialType);
    }

    public boolean isValid(RealmModel realm, UserModel user, CredentialInput input) {
        if (!(input instanceof UserCredentialModel)) {
            return false;
        }
        if (input.getType().equals("password") && !this.session.userCredentialManager().isConfiguredLocally(realm, user, "password")) {
            return this.validPassword(realm, user, input.getChallengeResponse());
        }
        return false;
    }

    public CredentialValidationOutput authenticate(RealmModel realm, CredentialInput cred) {
        UserCredentialModel credential;
        if (!(cred instanceof UserCredentialModel)) {
            CredentialValidationOutput.failed();
        }
        if ((credential = (UserCredentialModel)cred).getType().equals("kerberos") && this.kerberosConfig.isAllowKerberosAuthentication()) {
            String spnegoToken = credential.getChallengeResponse();
            SPNEGOAuthenticator spnegoAuthenticator = this.factory.createSPNEGOAuthenticator(spnegoToken, this.kerberosConfig);
            spnegoAuthenticator.authenticate();
            HashMap<String, String> state = new HashMap<String, String>();
            if (spnegoAuthenticator.isAuthenticated()) {
                String username = spnegoAuthenticator.getAuthenticatedUsername();
                UserModel user = this.findOrCreateAuthenticatedUser(realm, username);
                if (user == null) {
                    logger.warnf("Kerberos/SPNEGO authentication succeeded with username [%s], but couldn't find or create user with federation provider [%s]", (Object)username, (Object)this.model.getName());
                    return CredentialValidationOutput.failed();
                }
                String delegationCredential = spnegoAuthenticator.getSerializedDelegationCredential();
                if (delegationCredential != null) {
                    state.put("gss_delegation_credential", delegationCredential);
                }
                return new CredentialValidationOutput(user, CredentialValidationOutput.Status.AUTHENTICATED, state);
            }
            if (spnegoAuthenticator.getResponseToken() != null) {
                logger.tracef("SPNEGO Handshake will continue", new Object[0]);
                state.put("SpnegoResponseToken", spnegoAuthenticator.getResponseToken());
                return new CredentialValidationOutput(null, CredentialValidationOutput.Status.CONTINUE, state);
            }
            logger.tracef("SPNEGO Handshake not successful", new Object[0]);
            return CredentialValidationOutput.failed();
        }
        return CredentialValidationOutput.failed();
    }

    public void close() {
    }

    protected UserModel findOrCreateAuthenticatedUser(RealmModel realm, String username) {
        UserModel user = this.session.userLocalStorage().getUserByUsername(username, realm);
        if (user != null) {
            logger.debugf("Kerberos authenticated user [%s] found in Keycloak storage", (Object)username);
            if (!this.model.getId().equals(user.getFederationLink())) {
                logger.warnf("User with username [%s] already exists, but is not linked to provider [%s]", (Object)username, (Object)this.model.getName());
                return null;
            }
            LDAPObject ldapObject = this.loadAndValidateUser(realm, user);
            if (ldapObject != null) {
                return this.proxy(realm, user, ldapObject);
            }
            logger.warnf("User with username [%s] aready exists and is linked to provider [%s] but is not valid. Stale LDAP_ID on local user is: %s", (Object)username, (Object)this.model.getName(), (Object)user.getFirstAttribute("LDAP_ID"));
            logger.warn((Object)"Will re-create user");
            UserCache userCache = this.session.userCache();
            if (userCache != null) {
                userCache.evict(realm, user);
            }
            new UserManager(this.session).removeUser(realm, user, this.session.userLocalStorage());
        }
        logger.debugf("Kerberos authenticated user [%s] not in Keycloak storage. Creating him", (Object)username);
        return this.getUserByUsername(username, realm);
    }

    public LDAPObject loadLDAPUserByUsername(RealmModel realm, String username) {
        try (LDAPQuery ldapQuery = LDAPUtils.createQueryForUserSearch(this, realm);){
            LDAPQueryConditionsBuilder conditionsBuilder = new LDAPQueryConditionsBuilder();
            String usernameMappedAttribute = this.ldapIdentityStore.getConfig().getUsernameLdapAttribute();
            Condition usernameCondition = conditionsBuilder.equal(usernameMappedAttribute, username, EscapeStrategy.DEFAULT);
            ldapQuery.addWhereCondition(usernameCondition);
            LDAPObject ldapUser = ldapQuery.getFirstResult();
            if (ldapUser == null) {
                LDAPObject lDAPObject = null;
                return lDAPObject;
            }
            LDAPObject lDAPObject = ldapUser;
            return lDAPObject;
        }
    }
}

