/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import org.bouncycastle.openssl.PEMWriter;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.PasswordPolicy;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RequiredCredentialModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.SocialLinkModel;
import org.keycloak.models.UserCredentialModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.jpa.ApplicationAdapter;
import org.keycloak.models.jpa.OAuthClientAdapter;
import org.keycloak.models.jpa.RoleAdapter;
import org.keycloak.models.jpa.UserAdapter;
import org.keycloak.models.jpa.entities.ApplicationEntity;
import org.keycloak.models.jpa.entities.ApplicationScopeMappingEntity;
import org.keycloak.models.jpa.entities.ApplicationUserRoleMappingEntity;
import org.keycloak.models.jpa.entities.CredentialEntity;
import org.keycloak.models.jpa.entities.OAuthClientEntity;
import org.keycloak.models.jpa.entities.RealmEntity;
import org.keycloak.models.jpa.entities.RealmScopeMappingEntity;
import org.keycloak.models.jpa.entities.RealmUserRoleMappingEntity;
import org.keycloak.models.jpa.entities.RequiredCredentialEntity;
import org.keycloak.models.jpa.entities.RoleEntity;
import org.keycloak.models.jpa.entities.SocialLinkEntity;
import org.keycloak.models.jpa.entities.UserEntity;
import org.keycloak.models.utils.SHAPasswordEncoder;
import org.keycloak.models.utils.TimeBasedOTP;
import org.keycloak.util.PemUtils;

public class RealmAdapter
implements RealmModel {
    protected RealmEntity realm;
    protected EntityManager em;
    protected volatile transient PublicKey publicKey;
    protected volatile transient PrivateKey privateKey;
    private PasswordPolicy passwordPolicy;

    public RealmAdapter(EntityManager em, RealmEntity realm) {
        this.em = em;
        this.realm = realm;
    }

    public String getId() {
        return this.realm.getId();
    }

    public String getName() {
        return this.realm.getName();
    }

    public void setName(String name) {
        this.realm.setName(name);
        this.em.flush();
    }

    public boolean isEnabled() {
        return this.realm.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.realm.setEnabled(enabled);
        this.em.flush();
    }

    public boolean isSslNotRequired() {
        return this.realm.isSslNotRequired();
    }

    public void setSslNotRequired(boolean sslNotRequired) {
        this.realm.setSslNotRequired(sslNotRequired);
        this.em.flush();
    }

    public boolean isRegistrationAllowed() {
        return this.realm.isRegistrationAllowed();
    }

    public void setRegistrationAllowed(boolean registrationAllowed) {
        this.realm.setRegistrationAllowed(registrationAllowed);
        this.em.flush();
    }

    public boolean isVerifyEmail() {
        return this.realm.isVerifyEmail();
    }

    public void setVerifyEmail(boolean verifyEmail) {
        this.realm.setVerifyEmail(verifyEmail);
        this.em.flush();
    }

    public boolean isResetPasswordAllowed() {
        return this.realm.isResetPasswordAllowed();
    }

    public void setResetPasswordAllowed(boolean resetPasswordAllowed) {
        this.realm.setResetPasswordAllowed(resetPasswordAllowed);
        this.em.flush();
    }

    public int getTokenLifespan() {
        return this.realm.getTokenLifespan();
    }

    public void setTokenLifespan(int tokenLifespan) {
        this.realm.setTokenLifespan(tokenLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespan() {
        return this.realm.getAccessCodeLifespan();
    }

    public void setAccessCodeLifespan(int accessCodeLifespan) {
        this.realm.setAccessCodeLifespan(accessCodeLifespan);
        this.em.flush();
    }

    public int getAccessCodeLifespanUserAction() {
        return this.realm.getAccessCodeLifespanUserAction();
    }

    public void setAccessCodeLifespanUserAction(int accessCodeLifespanUserAction) {
        this.realm.setAccessCodeLifespanUserAction(accessCodeLifespanUserAction);
        this.em.flush();
    }

    public String getPublicKeyPem() {
        return this.realm.getPublicKeyPem();
    }

    public void setPublicKeyPem(String publicKeyPem) {
        this.realm.setPublicKeyPem(publicKeyPem);
        this.em.flush();
    }

    public String getPrivateKeyPem() {
        return this.realm.getPrivateKeyPem();
    }

    public void setPrivateKeyPem(String privateKeyPem) {
        this.realm.setPrivateKeyPem(privateKeyPem);
        this.em.flush();
    }

    public PublicKey getPublicKey() {
        if (this.publicKey != null) {
            return this.publicKey;
        }
        String pem = this.getPublicKeyPem();
        if (pem != null) {
            try {
                this.publicKey = PemUtils.decodePublicKey((String)pem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)publicKey);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.setPublicKeyPem(PemUtils.removeBeginEnd((String)s));
    }

    public PrivateKey getPrivateKey() {
        if (this.privateKey != null) {
            return this.privateKey;
        }
        String pem = this.getPrivateKeyPem();
        if (pem != null) {
            try {
                this.privateKey = PemUtils.decodePrivateKey((String)pem);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
        StringWriter writer = new StringWriter();
        PEMWriter pemWriter = new PEMWriter((Writer)writer);
        try {
            pemWriter.writeObject((Object)privateKey);
            pemWriter.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String s = writer.toString();
        this.setPrivateKeyPem(PemUtils.removeBeginEnd((String)s));
    }

    protected RequiredCredentialModel initRequiredCredentialModel(String type) {
        RequiredCredentialModel model = (RequiredCredentialModel)RequiredCredentialModel.BUILT_IN.get(type);
        if (model == null) {
            throw new RuntimeException("Unknown credential type " + type);
        }
        return model;
    }

    public void addRequiredCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredCredential(model);
        this.em.flush();
    }

    public void addRequiredCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredCredentials().add(entity);
        this.em.flush();
    }

    public void updateRequiredCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredCredential(cred);
        }
        this.em.flush();
    }

    public List<RequiredCredentialModel> getRequiredCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public List<RequiredCredentialModel> getRequiredApplicationCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredApplicationCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public List<RequiredCredentialModel> getRequiredOAuthClientCredentials() {
        ArrayList<RequiredCredentialModel> requiredCredentialModels = new ArrayList<RequiredCredentialModel>();
        Collection<RequiredCredentialEntity> entities = this.realm.getRequiredOAuthClientCredentials();
        if (entities == null) {
            return requiredCredentialModels;
        }
        for (RequiredCredentialEntity entity : entities) {
            RequiredCredentialModel model = new RequiredCredentialModel();
            model.setFormLabel(entity.getFormLabel());
            model.setType(entity.getType());
            model.setSecret(entity.isSecret());
            model.setInput(entity.isInput());
            requiredCredentialModels.add(model);
        }
        return requiredCredentialModels;
    }

    public void addRequiredOAuthClientCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredOAuthClientCredentials().add(entity);
        this.em.flush();
    }

    public void addRequiredOAuthClientCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredOAuthClientCredential(model);
        this.em.flush();
    }

    public void addRequiredResourceCredential(RequiredCredentialModel model) {
        RequiredCredentialEntity entity = new RequiredCredentialEntity();
        entity.setInput(model.isInput());
        entity.setSecret(model.isSecret());
        entity.setType(model.getType());
        entity.setFormLabel(model.getFormLabel());
        this.em.persist((Object)entity);
        this.realm.getRequiredApplicationCredentials().add(entity);
        this.em.flush();
    }

    public void addRequiredResourceCredential(String type) {
        RequiredCredentialModel model = this.initRequiredCredentialModel(type);
        this.addRequiredResourceCredential(model);
        this.em.flush();
    }

    public void updateRequiredOAuthClientCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredOAuthClientCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredOAuthClientCredential(cred);
        }
        this.em.flush();
    }

    public void updateRequiredApplicationCredentials(Set<String> creds) {
        Collection<RequiredCredentialEntity> relationships = this.realm.getRequiredApplicationCredentials();
        if (relationships == null) {
            relationships = new ArrayList<RequiredCredentialEntity>();
        }
        HashSet<String> already = new HashSet<String>();
        ArrayList<RequiredCredentialEntity> remove = new ArrayList<RequiredCredentialEntity>();
        for (RequiredCredentialEntity rel : relationships) {
            if (!creds.contains(rel.getType())) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getType());
        }
        for (RequiredCredentialEntity entity : remove) {
            relationships.remove(entity);
            this.em.remove((Object)entity);
        }
        for (String cred : creds) {
            if (already.contains(cred)) continue;
            this.addRequiredResourceCredential(cred);
        }
        this.em.flush();
    }

    public UserModel getUser(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByLoginName", UserEntity.class);
        query.setParameter("loginName", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        if (results.size() == 0) {
            return null;
        }
        return new UserAdapter((UserEntity)results.get(0));
    }

    public UserModel getUserByEmail(String email) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByEmail", UserEntity.class);
        query.setParameter("email", (Object)email);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        return results.isEmpty() ? null : new UserAdapter((UserEntity)results.get(0));
    }

    public UserModel addUser(String username) {
        UserEntity entity = new UserEntity();
        entity.setLoginName(username);
        entity.setRealm(this.realm);
        this.em.persist((Object)entity);
        this.em.flush();
        UserAdapter userModel = new UserAdapter(entity);
        for (String r : this.getDefaultRoles()) {
            this.grantRole(userModel, this.getRole(r));
        }
        for (ApplicationModel application : this.getApplications()) {
            for (String r : application.getDefaultRoles()) {
                application.grantRole((UserModel)userModel, application.getRole(r));
            }
        }
        return userModel;
    }

    public boolean removeUser(String name) {
        TypedQuery query = this.em.createNamedQuery("getRealmUserByLoginName", UserEntity.class);
        query.setParameter("loginName", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        if (results.size() == 0) {
            return false;
        }
        this.removeUser((UserEntity)results.get(0));
        return true;
    }

    private void removeUser(UserEntity user) {
        this.em.createQuery("delete from " + ApplicationScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.createQuery("delete from " + ApplicationUserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.createQuery("delete from " + RealmScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.createQuery("delete from " + RealmUserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.createQuery("delete from " + SocialLinkEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)user).executeUpdate();
        this.em.remove((Object)user);
    }

    public List<String> getDefaultRoles() {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        ArrayList<String> roles = new ArrayList<String>();
        if (entities == null) {
            return roles;
        }
        for (RoleEntity entity : entities) {
            roles.add(entity.getName());
        }
        return roles;
    }

    public void addDefaultRole(String name) {
        RoleModel role = this.getRole(name);
        if (role == null) {
            role = this.addRole(name);
        }
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        for (RoleEntity entity : entities) {
            if (!entity.getId().equals(role.getId())) continue;
            return;
        }
        entities.add(((RoleAdapter)role).getRole());
        this.em.flush();
    }

    public static boolean contains(String str, String[] array) {
        for (String s : array) {
            if (!str.equals(s)) continue;
            return true;
        }
        return false;
    }

    public void updateDefaultRoles(String[] defaultRoles) {
        Collection<RoleEntity> entities = this.realm.getDefaultRoles();
        HashSet<String> already = new HashSet<String>();
        ArrayList<RoleEntity> remove = new ArrayList<RoleEntity>();
        for (RoleEntity rel : entities) {
            if (!RealmAdapter.contains(rel.getName(), defaultRoles)) {
                remove.add(rel);
                continue;
            }
            already.add(rel.getName());
        }
        for (RoleEntity entity : remove) {
            entities.remove(entity);
        }
        this.em.flush();
        for (String roleName : defaultRoles) {
            if (already.contains(roleName)) continue;
            this.addDefaultRole(roleName);
        }
        this.em.flush();
    }

    public Map<String, ApplicationModel> getApplicationNameMap() {
        HashMap<String, ApplicationModel> map = new HashMap<String, ApplicationModel>();
        for (ApplicationModel app : this.getApplications()) {
            map.put(app.getName(), app);
        }
        return map;
    }

    public List<ApplicationModel> getApplications() {
        ArrayList<ApplicationModel> list = new ArrayList<ApplicationModel>();
        if (this.realm.getApplications() == null) {
            return list;
        }
        for (ApplicationEntity entity : this.realm.getApplications()) {
            list.add(new ApplicationAdapter(this.em, entity));
        }
        return list;
    }

    public ApplicationModel addApplication(String name) {
        ApplicationEntity applicationData = new ApplicationEntity();
        UserEntity user = new UserEntity();
        user.setLoginName(name);
        user.setRealm(this.realm);
        user.setEnabled(true);
        this.em.persist((Object)user);
        applicationData.setApplicationUser(user);
        applicationData.setName(name);
        applicationData.setEnabled(true);
        this.realm.getApplications().add(applicationData);
        this.em.persist((Object)applicationData);
        this.em.flush();
        ApplicationAdapter resource = new ApplicationAdapter(this.em, applicationData);
        this.em.flush();
        return resource;
    }

    public boolean removeApplication(String id) {
        ApplicationEntity application = null;
        for (ApplicationEntity a : this.realm.getApplications()) {
            if (!a.getId().equals(id)) continue;
            application = a;
        }
        if (application == null) {
            return false;
        }
        this.realm.getApplications().remove(application);
        this.em.createQuery("delete from " + ApplicationScopeMappingEntity.class.getSimpleName() + " where application = :application").setParameter("application", (Object)application).executeUpdate();
        this.em.createQuery("delete from " + ApplicationUserRoleMappingEntity.class.getSimpleName() + " where application = :application").setParameter("application", (Object)application).executeUpdate();
        this.em.createQuery("delete from " + ApplicationScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)application.getApplicationUser()).executeUpdate();
        this.em.createQuery("delete from " + RealmScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)application.getApplicationUser()).executeUpdate();
        this.em.createQuery("delete from " + ApplicationUserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)application.getApplicationUser()).executeUpdate();
        this.em.createQuery("delete from " + RealmUserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)application.getApplicationUser()).executeUpdate();
        this.removeUser(application.getApplicationUser());
        this.em.remove((Object)application);
        return true;
    }

    public ApplicationModel getApplicationById(String id) {
        ApplicationEntity app = (ApplicationEntity)this.em.find(ApplicationEntity.class, (Object)id);
        if (app == null) {
            return null;
        }
        return new ApplicationAdapter(this.em, app);
    }

    public ApplicationModel getApplicationByName(String name) {
        return this.getApplicationNameMap().get(name);
    }

    public UserModel getUserBySocialLink(SocialLinkModel socialLink) {
        TypedQuery query = this.em.createNamedQuery("findUserByLinkAndRealm", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("socialProvider", (Object)socialLink.getSocialProvider());
        query.setParameter("socialUsername", (Object)socialLink.getSocialUsername());
        List results = query.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new IllegalStateException("More results found for socialProvider=" + socialLink.getSocialProvider() + ", socialUsername=" + socialLink.getSocialUsername() + ", results=" + results);
        }
        UserEntity user = (UserEntity)results.get(0);
        return new UserAdapter(user);
    }

    public Set<SocialLinkModel> getSocialLinks(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByUser", SocialLinkEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        List results = query.getResultList();
        HashSet<SocialLinkModel> set = new HashSet<SocialLinkModel>();
        for (SocialLinkEntity entity : results) {
            set.add(new SocialLinkModel(entity.getSocialProvider(), entity.getSocialUsername()));
        }
        return set;
    }

    public void addSocialLink(UserModel user, SocialLinkModel socialLink) {
        SocialLinkEntity entity = new SocialLinkEntity();
        entity.setRealm(this.realm);
        entity.setSocialProvider(socialLink.getSocialProvider());
        entity.setSocialUsername(socialLink.getSocialUsername());
        entity.setUser(((UserAdapter)user).getUser());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void removeSocialLink(UserModel user, SocialLinkModel socialLink) {
        TypedQuery query = this.em.createNamedQuery("findSocialLinkByAll", SocialLinkEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        query.setParameter("socialProvider", (Object)socialLink.getSocialProvider());
        query.setParameter("socialUsername", (Object)socialLink.getSocialUsername());
        List results = query.getResultList();
        for (SocialLinkEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public boolean isSocial() {
        return this.realm.isSocial();
    }

    public void setSocial(boolean social) {
        this.realm.setSocial(social);
        this.em.flush();
    }

    public boolean isUpdateProfileOnInitialSocialLogin() {
        return this.realm.isUpdateProfileOnInitialSocialLogin();
    }

    public void setUpdateProfileOnInitialSocialLogin(boolean updateProfileOnInitialSocialLogin) {
        this.realm.setUpdateProfileOnInitialSocialLogin(updateProfileOnInitialSocialLogin);
        this.em.flush();
    }

    public List<UserModel> getUsers() {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public List<UserModel> searchForUser(String search) {
        TypedQuery query = this.em.createQuery("select u from UserEntity u where u.realm = :realm and ( lower(u.loginName) like :search or lower(concat(u.firstName, ' ', u.lastName)) like :search or u.email like :search )", UserEntity.class);
        query.setParameter("realm", (Object)this.realm);
        query.setParameter("search", (Object)("%" + search.toLowerCase() + "%"));
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public List<UserModel> searchForUserByAttributes(Map<String, String> attributes) {
        StringBuilder builder = new StringBuilder("select u from UserEntity u");
        boolean first = true;
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String attribute = null;
            if (entry.getKey().equals("username")) {
                attribute = "lower(loginName)";
            } else if (entry.getKey().equalsIgnoreCase("firstName")) {
                attribute = "lower(firstName)";
            } else if (entry.getKey().equalsIgnoreCase("lastName")) {
                attribute = "lower(lastName)";
            } else if (entry.getKey().equalsIgnoreCase("email")) {
                attribute = "lower(email)";
            }
            if (attribute == null) continue;
            if (first) {
                first = false;
                builder.append(" where ");
            } else {
                builder.append(" and ");
            }
            builder.append(attribute).append(" like '%").append(entry.getValue().toLowerCase()).append("%'");
        }
        String q = builder.toString();
        TypedQuery query = this.em.createQuery(q, UserEntity.class);
        List results = query.getResultList();
        ArrayList<UserModel> users = new ArrayList<UserModel>();
        for (UserEntity entity : results) {
            users.add(new UserAdapter(entity));
        }
        return users;
    }

    public OAuthClientModel addOAuthClient(String name) {
        OAuthClientEntity data = new OAuthClientEntity();
        UserEntity user = new UserEntity();
        user.setLoginName(name);
        user.setRealm(this.realm);
        user.setEnabled(true);
        this.em.persist((Object)user);
        data.setAgent(user);
        data.setName(name);
        data.setRealm(this.realm);
        this.em.persist((Object)data);
        this.em.flush();
        return new OAuthClientAdapter(data);
    }

    public boolean removeOAuthClient(String id) {
        OAuthClientEntity client = (OAuthClientEntity)this.em.find(OAuthClientEntity.class, (Object)id);
        this.em.createQuery("delete from " + ApplicationScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)client.getAgent()).executeUpdate();
        this.em.createQuery("delete from " + RealmScopeMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)client.getAgent()).executeUpdate();
        this.em.createQuery("delete from " + ApplicationUserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)client.getAgent()).executeUpdate();
        this.em.createQuery("delete from " + RealmUserRoleMappingEntity.class.getSimpleName() + " where user = :user").setParameter("user", (Object)client.getAgent()).executeUpdate();
        this.removeUser(client.getAgent());
        this.em.remove((Object)client);
        return true;
    }

    public OAuthClientModel getOAuthClient(String name) {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByUser", OAuthClientEntity.class);
        query.setParameter("name", (Object)name);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        if (entities.size() == 0) {
            return null;
        }
        return new OAuthClientAdapter((OAuthClientEntity)entities.get(0));
    }

    public OAuthClientModel getOAuthClientById(String id) {
        OAuthClientEntity client = (OAuthClientEntity)this.em.find(OAuthClientEntity.class, (Object)id);
        if (client == null) {
            return null;
        }
        return new OAuthClientAdapter(client);
    }

    public List<OAuthClientModel> getOAuthClients() {
        TypedQuery query = this.em.createNamedQuery("findOAuthClientByRealm", OAuthClientEntity.class);
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        ArrayList<OAuthClientModel> list = new ArrayList<OAuthClientModel>();
        for (OAuthClientEntity entity : entities) {
            list.add(new OAuthClientAdapter(entity));
        }
        return list;
    }

    public Map<String, String> getSmtpConfig() {
        return this.realm.getSmtpConfig();
    }

    public void setSmtpConfig(Map<String, String> smtpConfig) {
        this.realm.setSmtpConfig(smtpConfig);
        this.em.flush();
    }

    public Map<String, String> getSocialConfig() {
        return this.realm.getSocialConfig();
    }

    public void setSocialConfig(Map<String, String> socialConfig) {
        this.realm.setSocialConfig(socialConfig);
        this.em.flush();
    }

    public RoleModel getRole(String name) {
        Collection<RoleEntity> roles = this.realm.getRoles();
        if (roles == null) {
            return null;
        }
        for (RoleEntity role : roles) {
            if (!role.getName().equals(name)) continue;
            return new RoleAdapter(role);
        }
        return null;
    }

    public RoleModel addRole(String name) {
        RoleModel role = this.getRole(name);
        if (role != null) {
            return role;
        }
        RoleEntity entity = new RoleEntity();
        entity.setName(name);
        this.em.persist((Object)entity);
        this.realm.getRoles().add(entity);
        this.em.flush();
        return new RoleAdapter(entity);
    }

    public boolean removeRoleById(String id) {
        RoleEntity role = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (role == null) {
            return false;
        }
        this.realm.getRoles().remove(role);
        this.realm.getDefaultRoles().remove(role);
        this.em.createQuery("delete from " + ApplicationScopeMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createQuery("delete from " + ApplicationUserRoleMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createQuery("delete from " + RealmScopeMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.createQuery("delete from " + RealmUserRoleMappingEntity.class.getSimpleName() + " where role = :role").setParameter("role", (Object)role).executeUpdate();
        this.em.remove((Object)role);
        return true;
    }

    public List<RoleModel> getRoles() {
        ArrayList<RoleModel> list = new ArrayList<RoleModel>();
        Collection<RoleEntity> roles = this.realm.getRoles();
        if (roles == null) {
            return list;
        }
        for (RoleEntity entity : roles) {
            list.add(new RoleAdapter(entity));
        }
        return list;
    }

    public RoleModel getRoleById(String id) {
        RoleEntity entity = (RoleEntity)this.em.find(RoleEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new RoleAdapter(entity);
    }

    public boolean hasRole(UserModel user, RoleModel role) {
        TypedQuery<RealmUserRoleMappingEntity> query = this.getRealmUserRoleMappingEntityTypedQuery((UserAdapter)user, (RoleAdapter)role);
        return query.getResultList().size() > 0;
    }

    protected TypedQuery<RealmUserRoleMappingEntity> getRealmUserRoleMappingEntityTypedQuery(UserAdapter user, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("userHasRealmRole", RealmUserRoleMappingEntity.class);
        query.setParameter("user", (Object)user.getUser());
        query.setParameter("role", (Object)role.getRole());
        query.setParameter("realm", (Object)this.realm);
        return query;
    }

    public void grantRole(UserModel user, RoleModel role) {
        if (this.hasRole(user, role)) {
            return;
        }
        RealmUserRoleMappingEntity entity = new RealmUserRoleMappingEntity();
        entity.setRealm(this.realm);
        entity.setUser(((UserAdapter)user).getUser());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public List<RoleModel> getRoleMappings(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("userRealmMappings", RealmUserRoleMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        ArrayList<RoleModel> roles = new ArrayList<RoleModel>();
        for (RealmUserRoleMappingEntity entity : entities) {
            roles.add(new RoleAdapter(entity.getRole()));
        }
        return roles;
    }

    public Set<String> getRoleMappingValues(UserModel user) {
        TypedQuery query = this.em.createNamedQuery("userRealmMappings", RealmUserRoleMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)user).getUser());
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        HashSet<String> roles = new HashSet<String>();
        for (RealmUserRoleMappingEntity entity : entities) {
            roles.add(entity.getRole().getName());
        }
        return roles;
    }

    public void deleteRoleMapping(UserModel user, RoleModel role) {
        TypedQuery<RealmUserRoleMappingEntity> query = this.getRealmUserRoleMappingEntityTypedQuery((UserAdapter)user, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (RealmUserRoleMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
        this.em.flush();
    }

    public boolean hasRole(UserModel user, String roleName) {
        RoleModel role = this.getRole(roleName);
        if (role == null) {
            return false;
        }
        return this.hasRole(user, role);
    }

    public void addScopeMapping(UserModel agent, String roleName) {
        RoleModel role = this.getRole(roleName);
        if (role == null) {
            throw new RuntimeException("role does not exist");
        }
        this.addScopeMapping(agent, role);
        this.em.flush();
    }

    public Set<String> getScopeMappingValues(UserModel agent) {
        TypedQuery query = this.em.createNamedQuery("userRealmScopeMappings", RealmScopeMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)agent).getUser());
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        HashSet<String> roles = new HashSet<String>();
        for (RealmScopeMappingEntity entity : entities) {
            roles.add(entity.getRole().getName());
        }
        return roles;
    }

    public List<RoleModel> getScopeMappings(UserModel agent) {
        TypedQuery query = this.em.createNamedQuery("userRealmScopeMappings", RealmScopeMappingEntity.class);
        query.setParameter("user", (Object)((UserAdapter)agent).getUser());
        query.setParameter("realm", (Object)this.realm);
        List entities = query.getResultList();
        ArrayList<RoleModel> roles = new ArrayList<RoleModel>();
        for (RealmScopeMappingEntity entity : entities) {
            roles.add(new RoleAdapter(entity.getRole()));
        }
        return roles;
    }

    public void addScopeMapping(UserModel agent, RoleModel role) {
        if (this.hasScope(agent, role)) {
            return;
        }
        RealmScopeMappingEntity entity = new RealmScopeMappingEntity();
        entity.setRealm(this.realm);
        entity.setUser(((UserAdapter)agent).getUser());
        entity.setRole(((RoleAdapter)role).getRole());
        this.em.persist((Object)entity);
        this.em.flush();
    }

    public void deleteScopeMapping(UserModel user, RoleModel role) {
        TypedQuery<RealmScopeMappingEntity> query = this.getRealmScopeMappingQuery((UserAdapter)user, (RoleAdapter)role);
        List results = query.getResultList();
        if (results.size() == 0) {
            return;
        }
        for (RealmScopeMappingEntity entity : results) {
            this.em.remove((Object)entity);
        }
    }

    public boolean hasScope(UserModel user, RoleModel role) {
        TypedQuery<RealmScopeMappingEntity> query = this.getRealmScopeMappingQuery((UserAdapter)user, (RoleAdapter)role);
        return query.getResultList().size() > 0;
    }

    protected TypedQuery<RealmScopeMappingEntity> getRealmScopeMappingQuery(UserAdapter user, RoleAdapter role) {
        TypedQuery query = this.em.createNamedQuery("userHasRealmScope", RealmScopeMappingEntity.class);
        query.setParameter("user", (Object)user.getUser());
        query.setParameter("role", (Object)role.getRole());
        query.setParameter("realm", (Object)this.realm);
        return query;
    }

    public boolean validatePassword(UserModel user, String password) {
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("password")) continue;
            return new SHAPasswordEncoder(512).verify(password, cred.getValue());
        }
        return false;
    }

    public boolean validateTOTP(UserModel user, String password, String token) {
        if (!this.validatePassword(user, password)) {
            return false;
        }
        for (CredentialEntity cred : ((UserAdapter)user).getUser().getCredentials()) {
            if (!cred.getType().equals("totp")) continue;
            return new TimeBasedOTP().validate(token, cred.getValue().getBytes());
        }
        return false;
    }

    public void updateCredential(UserModel user, UserCredentialModel cred) {
        CredentialEntity credentialEntity = null;
        UserEntity userEntity = ((UserAdapter)user).getUser();
        for (CredentialEntity entity : userEntity.getCredentials()) {
            if (!entity.getType().equals(cred.getType())) continue;
            credentialEntity = entity;
        }
        if (credentialEntity == null) {
            credentialEntity = new CredentialEntity();
            credentialEntity.setType(cred.getType());
            credentialEntity.setDevice(cred.getDevice());
            credentialEntity.setUser(userEntity);
            this.em.persist((Object)credentialEntity);
            userEntity.getCredentials().add(credentialEntity);
        }
        if (cred.getType().equals("password")) {
            credentialEntity.setValue(new SHAPasswordEncoder(512).encode(cred.getValue()));
        } else {
            credentialEntity.setValue(cred.getValue());
        }
        credentialEntity.setDevice(cred.getDevice());
        this.em.flush();
    }

    public PasswordPolicy getPasswordPolicy() {
        if (this.passwordPolicy == null) {
            this.passwordPolicy = new PasswordPolicy(this.realm.getPasswordPolicy());
        }
        return this.passwordPolicy;
    }

    public void setPasswordPolicy(PasswordPolicy policy) {
        this.passwordPolicy = policy;
        this.realm.setPasswordPolicy(policy.toString());
        this.em.flush();
    }
}

