/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.core.DB2Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.logging.LogFactory;
import liquibase.logging.LogLevel;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.ServiceLocator;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.updater.liquibase.PostgresPlusDatabase;
import org.keycloak.connections.jpa.updater.liquibase.ThreadLocalSessionContext;
import org.keycloak.models.KeycloakSession;

public class LiquibaseJpaUpdaterProvider
implements JpaUpdaterProvider {
    private static final Logger logger = Logger.getLogger(LiquibaseJpaUpdaterProvider.class);
    private static final String CHANGELOG = "META-INF/jpa-changelog-master.xml";
    private static final String DB2_CHANGELOG = "META-INF/db2-jpa-changelog-master.xml";

    @Override
    public String getCurrentVersionSql(String defaultSchema) {
        return "SELECT ID from " + LiquibaseJpaUpdaterProvider.getTable("DATABASECHANGELOG", defaultSchema) + " ORDER BY DATEEXECUTED DESC LIMIT 1";
    }

    @Override
    public void update(KeycloakSession session, Connection connection, String defaultSchema) {
        logger.debug((Object)"Starting database update");
        ThreadLocalSessionContext.setCurrentSession(session);
        try {
            Liquibase liquibase = this.getLiquibase(connection, defaultSchema);
            List changeSets = liquibase.listUnrunChangeSets((Contexts)null);
            if (!changeSets.isEmpty()) {
                if (((ChangeSet)changeSets.get(0)).getId().equals("1.0.0.Final")) {
                    Statement statement = connection.createStatement();
                    try {
                        statement.executeQuery("SELECT id FROM " + LiquibaseJpaUpdaterProvider.getTable("REALM", defaultSchema));
                        logger.infov("Updating database from {0} to {1}", (Object)"1.0.0.Final", (Object)((ChangeSet)changeSets.get(changeSets.size() - 1)).getId());
                        liquibase.markNextChangeSetRan(null);
                    }
                    catch (SQLException e) {
                        logger.info((Object)"Initializing database schema");
                    }
                } else if (logger.isDebugEnabled()) {
                    List ranChangeSets = liquibase.getDatabase().getRanChangeSetList();
                    logger.debugv("Updating database from {0} to {1}", (Object)((RanChangeSet)ranChangeSets.get(ranChangeSets.size() - 1)).getId(), (Object)((ChangeSet)changeSets.get(changeSets.size() - 1)).getId());
                } else {
                    logger.infov("Updating database", new Object[0]);
                }
                liquibase.update((Contexts)null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update database", e);
        }
        finally {
            ThreadLocalSessionContext.removeCurrentSession();
        }
        logger.debug((Object)"Completed database update");
    }

    @Override
    public void validate(Connection connection, String defaultSchema) {
        try {
            Liquibase liquibase = this.getLiquibase(connection, defaultSchema);
            liquibase.validate();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to validate database", e);
        }
    }

    private Liquibase getLiquibase(Connection connection, String defaultSchema) throws Exception {
        ServiceLocator sl = ServiceLocator.getInstance();
        if (!System.getProperties().containsKey("liquibase.scan.packages")) {
            if (sl.getPackages().remove("liquibase.core")) {
                sl.addPackageToScan("liquibase.core.xml");
            }
            if (sl.getPackages().remove("liquibase.parser")) {
                sl.addPackageToScan("liquibase.parser.core.xml");
            }
            if (sl.getPackages().remove("liquibase.serializer")) {
                sl.addPackageToScan("liquibase.serializer.core.xml");
            }
            sl.getPackages().remove("liquibase.ext");
            sl.getPackages().remove("liquibase.sdk");
        }
        LogFactory.setInstance((LogFactory)new LogWrapper());
        DatabaseFactory.getInstance().register((Database)new PostgresPlusDatabase());
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        if (defaultSchema != null) {
            database.setDefaultSchemaName(defaultSchema);
        }
        String changelog = database instanceof DB2Database ? DB2_CHANGELOG : CHANGELOG;
        logger.debugf("Using changelog file: %s", (Object)changelog);
        return new Liquibase(changelog, (ResourceAccessor)new ClassLoaderResourceAccessor(this.getClass().getClassLoader()), database);
    }

    public void close() {
    }

    public static String getTable(String table, String defaultSchema) {
        return defaultSchema != null ? defaultSchema + "." + table : table;
    }

    private static class LogWrapper
    extends LogFactory {
        private liquibase.logging.Logger logger = new liquibase.logging.Logger(){

            public void setName(String name) {
            }

            public void setLogLevel(String level) {
            }

            public void setLogLevel(LogLevel level) {
            }

            public void setLogLevel(String logLevel, String logFile) {
            }

            public void severe(String message) {
                logger.error((Object)message);
            }

            public void severe(String message, Throwable e) {
                logger.error((Object)message, e);
            }

            public void warning(String message) {
                if ("Database does not support drop with cascade".equals(message)) {
                    logger.debug((Object)message);
                } else {
                    logger.warn((Object)message);
                }
            }

            public void warning(String message, Throwable e) {
                logger.warn((Object)message, e);
            }

            public void info(String message) {
                logger.debug((Object)message);
            }

            public void info(String message, Throwable e) {
                logger.debug((Object)message, e);
            }

            public void debug(String message) {
                logger.trace((Object)message);
            }

            public LogLevel getLogLevel() {
                if (logger.isTraceEnabled()) {
                    return LogLevel.DEBUG;
                }
                if (logger.isDebugEnabled()) {
                    return LogLevel.INFO;
                }
                return LogLevel.WARNING;
            }

            public void debug(String message, Throwable e) {
                logger.trace((Object)message, e);
            }

            public void setChangeLog(DatabaseChangeLog databaseChangeLog) {
            }

            public void setChangeSet(ChangeSet changeSet) {
            }

            public int getPriority() {
                return 0;
            }
        };

        private LogWrapper() {
        }

        public liquibase.logging.Logger getLog(String name) {
            return this.logger;
        }

        public liquibase.logging.Logger getLog() {
            return this.logger;
        }
    }
}

