/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.keycloak.models.jpa.entities.UserConsentEntity;

@NamedQueries(value={@NamedQuery(name="deleteUserConsentRolesByRealm", query="delete from UserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from UserConsentEntity consent where consent.user IN (select user from UserEntity user where user.realmId = :realmId))"), @NamedQuery(name="deleteUserConsentRolesByUser", query="delete from UserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from UserConsentEntity consent where consent.user = :user)"), @NamedQuery(name="deleteUserConsentRolesByRole", query="delete from UserConsentRoleEntity grantedRole where grantedRole.roleId = :roleId)"), @NamedQuery(name="deleteUserConsentRolesByClient", query="delete from UserConsentRoleEntity grantedRole where grantedRole.userConsent IN (select consent from UserConsentEntity consent where consent.clientId = :clientId)")})
@Entity
@Table(name="USER_CONSENT_ROLE")
@IdClass(value=Key.class)
public class UserConsentRoleEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_CONSENT_ID")
    protected UserConsentEntity userConsent;
    @Id
    @Column(name="ROLE_ID")
    protected String roleId;

    public UserConsentEntity getUserConsent() {
        return this.userConsent;
    }

    public void setUserConsent(UserConsentEntity userConsent) {
        this.userConsent = userConsent;
    }

    public String getRoleId() {
        return this.roleId;
    }

    public void setRoleId(String roleId) {
        this.roleId = roleId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserConsentRoleEntity)) {
            return false;
        }
        UserConsentRoleEntity that = (UserConsentRoleEntity)o;
        Key myKey = new Key(this.userConsent, this.roleId);
        Key hisKey = new Key(that.userConsent, that.roleId);
        return myKey.equals(hisKey);
    }

    public int hashCode() {
        Key myKey = new Key(this.userConsent, this.roleId);
        return myKey.hashCode();
    }

    public static class Key
    implements Serializable {
        protected UserConsentEntity userConsent;
        protected String roleId;

        public Key() {
        }

        public Key(UserConsentEntity userConsent, String roleId) {
            this.userConsent = userConsent;
            this.roleId = roleId;
        }

        public UserConsentEntity getUserConsent() {
            return this.userConsent;
        }

        public String getRoleId() {
            return this.roleId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.userConsent != null ? !this.userConsent.getId().equals(key.userConsent != null ? key.userConsent.getId() : null) : key.userConsent != null) {
                return false;
            }
            return !(this.roleId != null ? !this.roleId.equals(key.roleId) : key.roleId != null);
        }

        public int hashCode() {
            int result = this.userConsent != null ? this.userConsent.getId().hashCode() : 0;
            result = 31 * result + (this.roleId != null ? this.roleId.hashCode() : 0);
            return result;
        }
    }
}

