/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import liquibase.Contexts;
import liquibase.Liquibase;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.RanChangeSet;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.updater.JpaUpdaterProvider;
import org.keycloak.connections.jpa.updater.liquibase.ThreadLocalSessionContext;
import org.keycloak.connections.jpa.updater.liquibase.conn.LiquibaseConnectionProvider;
import org.keycloak.models.KeycloakSession;

public class LiquibaseJpaUpdaterProvider
implements JpaUpdaterProvider {
    private static final Logger logger = Logger.getLogger(LiquibaseJpaUpdaterProvider.class);
    public static final String CHANGELOG = "META-INF/jpa-changelog-master.xml";
    public static final String DB2_CHANGELOG = "META-INF/db2-jpa-changelog-master.xml";
    private final KeycloakSession session;

    public LiquibaseJpaUpdaterProvider(KeycloakSession session) {
        this.session = session;
    }

    @Override
    public String getCurrentVersionSql(String defaultSchema) {
        return "SELECT ID from " + LiquibaseJpaUpdaterProvider.getTable("DATABASECHANGELOG", defaultSchema) + " ORDER BY DATEEXECUTED DESC LIMIT 1";
    }

    @Override
    public void update(Connection connection, String defaultSchema) {
        logger.debug((Object)"Starting database update");
        ThreadLocalSessionContext.setCurrentSession(this.session);
        try {
            Liquibase liquibase = this.getLiquibase(connection, defaultSchema);
            List changeSets = liquibase.listUnrunChangeSets((Contexts)null);
            if (!changeSets.isEmpty()) {
                if (((ChangeSet)changeSets.get(0)).getId().equals("1.0.0.Final")) {
                    Statement statement = connection.createStatement();
                    try {
                        statement.executeQuery("SELECT id FROM " + LiquibaseJpaUpdaterProvider.getTable("REALM", defaultSchema));
                        logger.infov("Updating database from {0} to {1}", (Object)"1.0.0.Final", (Object)((ChangeSet)changeSets.get(changeSets.size() - 1)).getId());
                        liquibase.markNextChangeSetRan(null);
                    }
                    catch (SQLException e) {
                        logger.info((Object)"Initializing database schema");
                    }
                } else if (logger.isDebugEnabled()) {
                    List ranChangeSets = liquibase.getDatabase().getRanChangeSetList();
                    logger.debugv("Updating database from {0} to {1}", (Object)((RanChangeSet)ranChangeSets.get(ranChangeSets.size() - 1)).getId(), (Object)((ChangeSet)changeSets.get(changeSets.size() - 1)).getId());
                } else {
                    logger.infov("Updating database", new Object[0]);
                }
                liquibase.update((Contexts)null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to update database", e);
        }
        finally {
            ThreadLocalSessionContext.removeCurrentSession();
        }
        logger.debug((Object)"Completed database update");
    }

    @Override
    public void validate(Connection connection, String defaultSchema) {
        try {
            Liquibase liquibase = this.getLiquibase(connection, defaultSchema);
            liquibase.validate();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to validate database", e);
        }
    }

    private Liquibase getLiquibase(Connection connection, String defaultSchema) throws Exception {
        LiquibaseConnectionProvider liquibaseProvider = (LiquibaseConnectionProvider)this.session.getProvider(LiquibaseConnectionProvider.class);
        return liquibaseProvider.getLiquibase(connection, defaultSchema);
    }

    public void close() {
    }

    public static String getTable(String table, String defaultSchema) {
        return defaultSchema != null ? defaultSchema + "." + table : table;
    }
}

