/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.entities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.model.Policy;
import org.keycloak.authorization.model.Resource;
import org.keycloak.authorization.model.Scope;
import org.keycloak.representations.idm.authorization.DecisionStrategy;
import org.keycloak.representations.idm.authorization.Logic;

@Entity
@Table(name="RESOURCE_SERVER_POLICY", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "RESOURCE_SERVER_ID"})})
public class PolicyEntity
implements Policy {
    @Id
    @Column(name="ID", length=36)
    @Access(value=AccessType.PROPERTY)
    private String id;
    @Column(name="NAME")
    private String name;
    @Column(name="DESCRIPTION")
    private String description;
    @Column(name="TYPE")
    private String type;
    @Column(name="DECISION_STRATEGY")
    private DecisionStrategy decisionStrategy = DecisionStrategy.UNANIMOUS;
    @Column(name="LOGIC")
    private Logic logic = Logic.POSITIVE;
    @ElementCollection
    @MapKeyColumn(name="NAME")
    @Column(name="VALUE", columnDefinition="TEXT")
    @CollectionTable(name="POLICY_CONFIG", joinColumns={@JoinColumn(name="POLICY_ID")})
    private Map<String, String> config = new HashMap<String, String>();
    @ManyToOne(optional=false)
    @JoinColumn(name="RESOURCE_SERVER_ID")
    private ResourceServerEntity resourceServer;
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="ASSOCIATED_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="ASSOCIATED_POLICY_ID")})
    private Set<PolicyEntity> associatedPolicies = new HashSet<PolicyEntity>();
    @ManyToMany(fetch=FetchType.LAZY, cascade={})
    @JoinTable(name="RESOURCE_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="RESOURCE_ID")})
    private Set<ResourceEntity> resources = new HashSet<ResourceEntity>();
    @ManyToMany(fetch=FetchType.EAGER, cascade={})
    @JoinTable(name="SCOPE_POLICY", joinColumns={@JoinColumn(name="POLICY_ID")}, inverseJoinColumns={@JoinColumn(name="SCOPE_ID")})
    private Set<ScopeEntity> scopes = new HashSet<ScopeEntity>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DecisionStrategy getDecisionStrategy() {
        return this.decisionStrategy;
    }

    public void setDecisionStrategy(DecisionStrategy decisionStrategy) {
        this.decisionStrategy = decisionStrategy;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public void setLogic(Logic logic) {
        this.logic = logic;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ResourceServerEntity getResourceServer() {
        return this.resourceServer;
    }

    public void setResourceServer(ResourceServerEntity resourceServer) {
        this.resourceServer = resourceServer;
    }

    public <P extends Policy> Set<P> getAssociatedPolicies() {
        return this.associatedPolicies;
    }

    public void setAssociatedPolicies(Set<PolicyEntity> associatedPolicies) {
        this.associatedPolicies = associatedPolicies;
    }

    public Set<ResourceEntity> getResources() {
        return this.resources;
    }

    public void setResources(Set<ResourceEntity> resources) {
        this.resources = resources;
    }

    public Set<ScopeEntity> getScopes() {
        return this.scopes;
    }

    public void setScopes(Set<ScopeEntity> scopes) {
        this.scopes = scopes;
    }

    public void addScope(Scope scope) {
        this.getScopes().add((ScopeEntity)scope);
    }

    public void removeScope(Scope scope) {
        this.getScopes().remove(scope);
    }

    public void addAssociatedPolicy(Policy associatedPolicy) {
        this.getAssociatedPolicies().add(associatedPolicy);
    }

    public void removeAssociatedPolicy(Policy associatedPolicy) {
        this.getAssociatedPolicies().remove(associatedPolicy);
    }

    public void addResource(Resource resource) {
        this.getResources().add((ResourceEntity)resource);
    }

    public void removeResource(Resource resource) {
        this.getResources().remove(resource);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (this.id == null) {
            return false;
        }
        if (!Policy.class.isInstance(o)) {
            return false;
        }
        Policy that = (Policy)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : super.hashCode();
    }
}

