/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAResourceServerStore
implements ResourceServerStore {
    private final EntityManager entityManager;

    public JPAResourceServerStore(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public ResourceServer create(String clientId) {
        ResourceServerEntity entity = new ResourceServerEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setClientId(clientId);
        this.entityManager.persist((Object)entity);
        return entity;
    }

    public void delete(String id) {
        this.entityManager.remove((Object)this.findById(id));
    }

    public ResourceServer findById(String id) {
        return (ResourceServer)this.entityManager.find(ResourceServerEntity.class, (Object)id);
    }

    public ResourceServer findByClient(String clientId) {
        Query query = this.entityManager.createQuery("from ResourceServerEntity where clientId = :clientId");
        query.setParameter("clientId", (Object)clientId);
        List result = query.getResultList();
        if (result.isEmpty()) {
            return null;
        }
        return (ResourceServer)result.get(0);
    }
}

