/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.LinkedList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.PolicyEntity;
import org.keycloak.authorization.jpa.entities.ResourceEntity;
import org.keycloak.authorization.jpa.entities.ResourceServerEntity;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.store.ResourceServerStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAResourceServerStore
implements ResourceServerStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAResourceServerStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public ResourceServer create(String clientId) {
        ResourceServerEntity entity = new ResourceServerEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setClientId(clientId);
        this.entityManager.persist((Object)entity);
        return new ResourceServerAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public void delete(String id) {
        ResourceServerEntity entity = (ResourceServerEntity)this.entityManager.find(ResourceServerEntity.class, (Object)id);
        if (entity == null) {
            return;
        }
        TypedQuery query = this.entityManager.createNamedQuery("findPolicyIdByServerId", String.class);
        query.setParameter("serverId", (Object)id);
        List result = query.getResultList();
        for (Object policyId : result) {
            this.entityManager.remove(this.entityManager.getReference(PolicyEntity.class, policyId));
        }
        query = this.entityManager.createNamedQuery("findResourceIdByServerId", String.class);
        query.setParameter("serverId", (Object)id);
        result = query.getResultList();
        LinkedList list = new LinkedList();
        for (String resourceId : result) {
            this.entityManager.remove(this.entityManager.getReference(ResourceEntity.class, (Object)resourceId));
        }
        query = this.entityManager.createNamedQuery("findScopeIdByResourceServer", String.class);
        query.setParameter("serverId", (Object)id);
        result = query.getResultList();
        for (String scopeId : result) {
            this.entityManager.remove(this.entityManager.getReference(ScopeEntity.class, (Object)scopeId));
        }
        this.entityManager.remove((Object)entity);
        this.entityManager.flush();
        this.entityManager.detach((Object)entity);
    }

    public ResourceServer findById(String id) {
        ResourceServerEntity entity = (ResourceServerEntity)this.entityManager.find(ResourceServerEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new ResourceServerAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public ResourceServer findByClient(String clientId) {
        TypedQuery query = this.entityManager.createNamedQuery("findResourceServerIdByClient", String.class);
        query.setParameter("clientId", (Object)clientId);
        try {
            String id = (String)query.getSingleResult();
            return this.provider.getStoreFactory().getResourceServerStore().findById(id);
        }
        catch (NoResultException ex) {
            return null;
        }
    }
}

