/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.jpa.store;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.keycloak.authorization.AuthorizationProvider;
import org.keycloak.authorization.jpa.entities.ScopeEntity;
import org.keycloak.authorization.jpa.store.ResourceServerAdapter;
import org.keycloak.authorization.jpa.store.ScopeAdapter;
import org.keycloak.authorization.model.ResourceServer;
import org.keycloak.authorization.model.Scope;
import org.keycloak.authorization.store.ScopeStore;
import org.keycloak.models.utils.KeycloakModelUtils;

public class JPAScopeStore
implements ScopeStore {
    private final EntityManager entityManager;
    private final AuthorizationProvider provider;

    public JPAScopeStore(EntityManager entityManager, AuthorizationProvider provider) {
        this.entityManager = entityManager;
        this.provider = provider;
    }

    public Scope create(String name, ResourceServer resourceServer) {
        ScopeEntity entity = new ScopeEntity();
        entity.setId(KeycloakModelUtils.generateId());
        entity.setName(name);
        entity.setResourceServer(ResourceServerAdapter.toEntity(this.entityManager, resourceServer));
        this.entityManager.persist((Object)entity);
        this.entityManager.flush();
        return new ScopeAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public void delete(String id) {
        ScopeEntity scope = (ScopeEntity)this.entityManager.find(ScopeEntity.class, (Object)id);
        if (scope != null) {
            this.entityManager.remove((Object)scope);
        }
    }

    public Scope findById(String id, String resourceServerId) {
        if (id == null) {
            return null;
        }
        ScopeEntity entity = (ScopeEntity)this.entityManager.find(ScopeEntity.class, (Object)id);
        if (entity == null) {
            return null;
        }
        return new ScopeAdapter(entity, this.entityManager, this.provider.getStoreFactory());
    }

    public Scope findByName(String name, String resourceServerId) {
        try {
            TypedQuery query = this.entityManager.createNamedQuery("findScopeIdByName", String.class);
            query.setFlushMode(FlushModeType.COMMIT);
            query.setParameter("serverId", (Object)resourceServerId);
            query.setParameter("name", (Object)name);
            String id = (String)query.getSingleResult();
            return this.provider.getStoreFactory().getScopeStore().findById(id, resourceServerId);
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public List<Scope> findByResourceServer(String serverId) {
        TypedQuery query = this.entityManager.createNamedQuery("findScopeIdByResourceServer", String.class);
        query.setFlushMode(FlushModeType.COMMIT);
        query.setParameter("serverId", (Object)serverId);
        List result = query.getResultList();
        LinkedList<Scope> list = new LinkedList<Scope>();
        for (String id : result) {
            list.add(this.provider.getStoreFactory().getScopeStore().findById(id, serverId));
        }
        return list;
    }

    public List<Scope> findByResourceServer(Map<String, String[]> attributes, String resourceServerId, int firstResult, int maxResult) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery querybuilder = builder.createQuery(ScopeEntity.class);
        Root root = querybuilder.from(ScopeEntity.class);
        querybuilder.select((Selection)root.get("id"));
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(builder.equal((Expression)root.get("resourceServer").get("id"), (Object)resourceServerId));
        attributes.forEach((name, value) -> {
            if ("id".equals(name)) {
                predicates.add(root.get(name).in((Object[])value));
            } else {
                predicates.add(builder.like(builder.lower((Expression)root.get(name)), "%" + value[0].toLowerCase() + "%"));
            }
        });
        querybuilder.where(predicates.toArray(new Predicate[predicates.size()])).orderBy(new Order[]{builder.asc((Expression)root.get("name"))});
        TypedQuery query = this.entityManager.createQuery(querybuilder);
        if (firstResult != -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query.setMaxResults(maxResult);
        }
        List result = query.getResultList();
        LinkedList<Scope> list = new LinkedList<Scope>();
        for (Object id : result) {
            list.add(this.provider.getStoreFactory().getScopeStore().findById((String)id, resourceServerId));
        }
        return list;
    }
}

