/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.credential.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Base64;

public class PasswordSecretData {
    public static final Logger logger = Logger.getLogger(PasswordSecretData.class);
    private final String value;
    private final byte[] salt;

    @JsonCreator
    public PasswordSecretData(@JsonProperty(value="value") String value, @JsonProperty(value="salt") String salt) throws IOException {
        if (salt == null || "__SALT__".equals(salt)) {
            this.value = value;
            this.salt = null;
        } else {
            this.value = value;
            this.salt = Base64.decode((String)salt);
        }
    }

    public PasswordSecretData(String value, byte[] salt) {
        this.value = value;
        this.salt = salt;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getSalt() {
        return this.salt;
    }
}

