/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;

public class DefaultRoles {
    public static Stream<RoleModel> getDefaultRoles(RealmModel realm) {
        Stream<RoleModel> realmDefaultRoles = realm.getDefaultRolesStream().map(realm::getRole);
        Stream clientDefaultRoles = realm.getClientsStream().flatMap(DefaultRoles::toClientDefaultRoles);
        return Stream.concat(realmDefaultRoles, clientDefaultRoles);
    }

    public static void addDefaultRoles(RealmModel realm, UserModel userModel) {
        DefaultRoles.getDefaultRoles(realm).forEach(userModel::grantRole);
    }

    private static Stream<RoleModel> toClientDefaultRoles(ClientModel c) {
        return c.getDefaultRolesStream().map(c::getRole);
    }
}

