/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.keycloak.models.KeycloakSession;
import org.keycloak.policy.PasswordPolicyProvider;

public class PasswordPolicy
implements Serializable {
    public static final String HASH_ALGORITHM_ID = "hashAlgorithm";
    public static final String HASH_ALGORITHM_DEFAULT = "pbkdf2";
    public static final String HASH_ITERATIONS_ID = "hashIterations";
    public static final int HASH_ITERATIONS_DEFAULT = 20000;
    public static final String PASSWORD_HISTORY_ID = "passwordHistory";
    public static final String FORCE_EXPIRED_ID = "forceExpiredPasswordChange";
    private String policyString;
    private Map<String, Object> policyConfig;

    public static PasswordPolicy empty() {
        return new PasswordPolicy(null, new HashMap<String, Object>());
    }

    public static PasswordPolicy parse(KeycloakSession session, String policyString) {
        HashMap<String, Object> policyConfig = new HashMap<String, Object>();
        if (policyString != null && !policyString.trim().isEmpty()) {
            for (String policy : policyString.split(" and ")) {
                String key;
                policy = policy.trim();
                String config = null;
                int i = policy.indexOf(40);
                if (i == -1) {
                    key = policy.trim();
                } else {
                    key = policy.substring(0, i).trim();
                    config = policy.substring(i + 1, policy.length() - 1);
                }
                PasswordPolicyProvider provider = session.getProvider(PasswordPolicyProvider.class, key);
                if (provider == null) {
                    throw new IllegalArgumentException("Unsupported policy");
                }
                policyConfig.put(key, provider.parseConfig(config));
            }
        }
        return new PasswordPolicy(policyString, policyConfig);
    }

    private PasswordPolicy(String policyString, Map<String, Object> policyConfig) {
        this.policyString = policyString;
        this.policyConfig = policyConfig;
    }

    public Set<String> getPolicies() {
        return this.policyConfig.keySet();
    }

    public <T> T getPolicyConfig(String key) {
        return (T)this.policyConfig.get(key);
    }

    public String getHashAlgorithm() {
        if (this.policyConfig.containsKey(HASH_ALGORITHM_ID)) {
            return (String)this.getPolicyConfig(HASH_ALGORITHM_ID);
        }
        return HASH_ALGORITHM_DEFAULT;
    }

    public int getHashIterations() {
        if (this.policyConfig.containsKey(HASH_ITERATIONS_ID)) {
            return (Integer)this.getPolicyConfig(HASH_ITERATIONS_ID);
        }
        return 20000;
    }

    public int getExpiredPasswords() {
        if (this.policyConfig.containsKey(PASSWORD_HISTORY_ID)) {
            return (Integer)this.getPolicyConfig(PASSWORD_HISTORY_ID);
        }
        return -1;
    }

    public int getDaysToExpirePassword() {
        if (this.policyConfig.containsKey(FORCE_EXPIRED_ID)) {
            return (Integer)this.getPolicyConfig(FORCE_EXPIRED_ID);
        }
        return -1;
    }

    public String toString() {
        return this.policyString;
    }
}

