/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.crypto.SecretKey;
import org.keycloak.keys.RsaKeyMetadata;
import org.keycloak.keys.SecretKeyMetadata;
import org.keycloak.models.RealmModel;

public interface KeyManager {
    public ActiveRsaKey getActiveRsaKey(RealmModel var1);

    public PublicKey getRsaPublicKey(RealmModel var1, String var2);

    public Certificate getRsaCertificate(RealmModel var1, String var2);

    public List<RsaKeyMetadata> getRsaKeys(RealmModel var1, boolean var2);

    public ActiveHmacKey getActiveHmacKey(RealmModel var1);

    public SecretKey getHmacSecretKey(RealmModel var1, String var2);

    public List<SecretKeyMetadata> getHmacKeys(RealmModel var1, boolean var2);

    public ActiveAesKey getActiveAesKey(RealmModel var1);

    public SecretKey getAesSecretKey(RealmModel var1, String var2);

    public List<SecretKeyMetadata> getAesKeys(RealmModel var1, boolean var2);

    public static class ActiveAesKey {
        private final String kid;
        private final SecretKey secretKey;

        public ActiveAesKey(String kid, SecretKey secretKey) {
            this.kid = kid;
            this.secretKey = secretKey;
        }

        public String getKid() {
            return this.kid;
        }

        public SecretKey getSecretKey() {
            return this.secretKey;
        }
    }

    public static class ActiveHmacKey {
        private final String kid;
        private final SecretKey secretKey;

        public ActiveHmacKey(String kid, SecretKey secretKey) {
            this.kid = kid;
            this.secretKey = secretKey;
        }

        public String getKid() {
            return this.kid;
        }

        public SecretKey getSecretKey() {
            return this.secretKey;
        }
    }

    public static class ActiveRsaKey {
        private final String kid;
        private final PrivateKey privateKey;
        private final PublicKey publicKey;
        private final X509Certificate certificate;

        public ActiveRsaKey(String kid, PrivateKey privateKey, PublicKey publicKey, X509Certificate certificate) {
            this.kid = kid;
            this.privateKey = privateKey;
            this.publicKey = publicKey;
            this.certificate = certificate;
        }

        public String getKid() {
            return this.kid;
        }

        public PrivateKey getPrivateKey() {
            return this.privateKey;
        }

        public PublicKey getPublicKey() {
            return this.publicKey;
        }

        public X509Certificate getCertificate() {
            return this.certificate;
        }
    }
}

