/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.audit.AuditProvider;
import org.keycloak.audit.Event;
import org.keycloak.audit.EventQuery;
import org.keycloak.audit.EventType;
import org.keycloak.models.ApplicationModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleContainerModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.provider.ProviderSession;
import org.keycloak.representations.adapters.action.SessionStats;
import org.keycloak.representations.idm.RealmAuditRepresentation;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.services.managers.ModelToRepresentation;
import org.keycloak.services.managers.RealmManager;
import org.keycloak.services.managers.ResourceAdminManager;
import org.keycloak.services.managers.TokenManager;
import org.keycloak.services.resources.admin.ApplicationsResource;
import org.keycloak.services.resources.admin.OAuthClientsResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.admin.RoleByIdResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.UsersResource;
import org.keycloak.services.resources.flows.Flows;

public class RealmAdminResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmAuth auth;
    protected RealmModel realm;
    private TokenManager tokenManager;
    @Context
    protected KeycloakSession session;
    @Context
    protected ProviderSession providers;
    @Context
    protected UriInfo uriInfo;

    public RealmAdminResource(RealmAuth auth, RealmModel realm, TokenManager tokenManager) {
        this.auth = auth;
        this.realm = realm;
        this.tokenManager = tokenManager;
        auth.init(RealmAuth.Resource.REALM);
    }

    @Path(value="applications")
    public ApplicationsResource getApplications() {
        ApplicationsResource applicationsResource = new ApplicationsResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)applicationsResource);
        return applicationsResource;
    }

    @Path(value="oauth-clients")
    public OAuthClientsResource getOAuthClients() {
        OAuthClientsResource oauth = new OAuthClientsResource(this.realm, this.auth, this.session);
        ResteasyProviderFactory.getInstance().injectProperties((Object)oauth);
        return oauth;
    }

    @Path(value="roles")
    public RoleContainerResource getRoleContainerResource() {
        return new RoleContainerResource(this.realm, this.auth, (RoleContainerModel)this.realm);
    }

    @GET
    @NoCache
    @Produces(value={"application/json"})
    public RealmRepresentation getRealm() {
        if (this.auth.hasView()) {
            return ModelToRepresentation.toRepresentation(this.realm);
        }
        this.auth.requireAny();
        RealmRepresentation rep = new RealmRepresentation();
        rep.setRealm(this.realm.getName());
        return rep;
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response updateRealm(RealmRepresentation rep) {
        this.auth.requireManage();
        logger.debug((Object)("updating realm: " + this.realm.getName()));
        try {
            new RealmManager(this.session).updateRealm(rep, this.realm);
            return Response.noContent().build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Realm " + rep.getRealm() + " already exists");
        }
    }

    @DELETE
    public void deleteRealm() {
        this.auth.requireManage();
        if (!new RealmManager(this.session).removeRealm(this.realm)) {
            throw new NotFoundException("Realm doesn't exist");
        }
    }

    @Path(value="users")
    public UsersResource users() {
        UsersResource users = new UsersResource(this.providers, this.realm, this.auth, this.tokenManager);
        ResteasyProviderFactory.getInstance().injectProperties((Object)users);
        return users;
    }

    @Path(value="roles-by-id")
    public RoleByIdResource rolesById() {
        RoleByIdResource resource = new RoleByIdResource(this.realm, this.auth);
        ResteasyProviderFactory.getInstance().injectProperties((Object)resource);
        return resource;
    }

    @Path(value="push-revocation")
    @POST
    public void pushRevocation() {
        this.auth.requireManage();
        new ResourceAdminManager().pushRealmRevocationPolicy(this.uriInfo.getRequestUri(), this.realm);
    }

    @Path(value="logout-all")
    @POST
    public void logoutAll() {
        this.auth.requireManage();
        this.realm.removeUserSessions();
        new ResourceAdminManager().logoutAll(this.uriInfo.getRequestUri(), this.realm);
    }

    @Path(value="sessions/{session}")
    @DELETE
    public void deleteSession(@PathParam(value="session") String sessionId) {
        UserSessionModel session = this.realm.getUserSession(sessionId);
        if (session == null) {
            throw new NotFoundException("Sesssion not found");
        }
        this.realm.removeUserSession(session);
        new ResourceAdminManager().logoutSession(this.uriInfo.getRequestUri(), this.realm, session.getId());
    }

    @Path(value="application-session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, Integer> getApplicationSessionStats() {
        this.auth.requireView();
        HashMap<String, Integer> stats = new HashMap<String, Integer>();
        for (ApplicationModel applicationModel : this.realm.getApplications()) {
            int size = applicationModel.getActiveUserSessions();
            if (size == 0) continue;
            stats.put(applicationModel.getName(), size);
        }
        return stats;
    }

    @Path(value="session-stats")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public Map<String, SessionStats> getSessionStats() {
        logger.info((Object)"session-stats");
        this.auth.requireView();
        HashMap<String, SessionStats> stats = new HashMap<String, SessionStats>();
        for (ApplicationModel applicationModel : this.realm.getApplications()) {
            if (applicationModel.getManagementUrl() == null) continue;
            SessionStats appStats = new ResourceAdminManager().getSessionStats(this.uriInfo.getRequestUri(), this.realm, applicationModel, false);
            stats.put(applicationModel.getName(), appStats);
        }
        return stats;
    }

    @GET
    @Path(value="audit")
    @Produces(value={"application/json"})
    public RealmAuditRepresentation getRealmAudit() {
        this.auth.init(RealmAuth.Resource.AUDIT).requireView();
        return ModelToRepresentation.toAuditReprensetation(this.realm);
    }

    @PUT
    @Path(value="audit")
    @Consumes(value={"application/json"})
    public void updateRealmAudit(RealmAuditRepresentation rep) {
        this.auth.init(RealmAuth.Resource.AUDIT).requireManage();
        logger.debug((Object)("updating realm audit: " + this.realm.getName()));
        new RealmManager(this.session).updateRealmAudit(rep, this.realm);
    }

    @Path(value="audit/events")
    @GET
    @NoCache
    @Produces(value={"application/json"})
    public List<Event> getAudit(@QueryParam(value="client") String client, @QueryParam(value="event") String event, @QueryParam(value="user") String user, @QueryParam(value="ipAddress") String ipAddress, @QueryParam(value="first") Integer firstResult, @QueryParam(value="max") Integer maxResults) {
        this.auth.init(RealmAuth.Resource.AUDIT).requireView();
        AuditProvider audit = (AuditProvider)this.providers.getProvider(AuditProvider.class);
        EventQuery query = audit.createQuery().realm(this.realm.getId());
        if (client != null) {
            query.client(client);
        }
        if (event != null) {
            query.event(new EventType[]{EventType.valueOf((String)event)});
        }
        if (user != null) {
            query.user(user);
        }
        if (ipAddress != null) {
            query.ipAddress(ipAddress);
        }
        if (firstResult != null) {
            query.firstResult(firstResult.intValue());
        }
        if (maxResults != null) {
            query.maxResults(maxResults.intValue());
        }
        return query.getResultList();
    }

    @Path(value="audit/events")
    @DELETE
    public void clearAudit() {
        this.auth.init(RealmAuth.Resource.AUDIT).requireManage();
        AuditProvider audit = (AuditProvider)this.providers.getProvider(AuditProvider.class);
        audit.clear(this.realm.getId());
    }
}

