/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.Provider;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.Spi;
import org.keycloak.services.DefaultKeycloakSession;

public class DefaultKeycloakSessionFactory
implements KeycloakSessionFactory {
    private static final Logger log = Logger.getLogger(DefaultKeycloakSessionFactory.class);
    private Map<Class<? extends Provider>, String> provider = new HashMap<Class<? extends Provider>, String>();
    private Map<Class<? extends Provider>, Map<String, ProviderFactory>> factoriesMap = new HashMap<Class<? extends Provider>, Map<String, ProviderFactory>>();

    public void init() {
        for (Spi spi : ServiceLoader.load(Spi.class)) {
            HashMap<String, ProviderFactory> factories = new HashMap<String, ProviderFactory>();
            this.factoriesMap.put(spi.getProviderClass(), factories);
            String provider = Config.getProvider((String)spi.getName());
            if (provider != null) {
                this.provider.put(spi.getProviderClass(), provider);
                ProviderFactory factory = this.loadProviderFactory(spi, provider);
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), provider});
                factory.init(scope);
                factories.put(factory.getId(), factory);
                log.info((Object)("Loaded SPI " + spi.getName() + " (provider = " + provider + ")"));
                continue;
            }
            for (ProviderFactory factory : ServiceLoader.load(spi.getProviderFactoryClass())) {
                Config.Scope scope = Config.scope((String[])new String[]{spi.getName(), factory.getId()});
                factory.init(scope);
                factories.put(factory.getId(), factory);
            }
            if (factories.size() == 1) {
                provider = ((ProviderFactory)factories.values().iterator().next()).getId();
                this.provider.put(spi.getProviderClass(), provider);
                log.info((Object)("Loaded SPI " + spi.getName() + " (provider = " + provider + ")"));
                continue;
            }
            log.info((Object)("Loaded SPI " + spi.getName() + " (providers = " + factories.keySet() + ")"));
        }
    }

    private ProviderFactory loadProviderFactory(Spi spi, String id) {
        for (ProviderFactory factory : ServiceLoader.load(spi.getProviderFactoryClass())) {
            if (!factory.getId().equals(id)) continue;
            return factory;
        }
        throw new RuntimeException("Failed to find provider " + id + " for " + spi.getName());
    }

    public KeycloakSession create() {
        return new DefaultKeycloakSession(this);
    }

    <T extends Provider> String getDefaultProvider(Class<T> clazz) {
        return this.provider.get(clazz);
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz) {
        return this.getProviderFactory(clazz, this.provider.get(clazz));
    }

    public <T extends Provider> ProviderFactory<T> getProviderFactory(Class<T> clazz, String id) {
        return this.factoriesMap.get(clazz).get(id);
    }

    public List<ProviderFactory> getProviderFactories(Class<? extends Provider> clazz) {
        LinkedList<ProviderFactory> list = new LinkedList<ProviderFactory>();
        if (this.factoriesMap == null) {
            return list;
        }
        Map<String, ProviderFactory> providerFactoryMap = this.factoriesMap.get(clazz);
        if (providerFactoryMap == null) {
            return list;
        }
        list.addAll(providerFactoryMap.values());
        return list;
    }

    <T extends Provider> Set<String> getAllProviderIds(Class<T> clazz) {
        HashSet<String> ids = new HashSet<String>();
        for (ProviderFactory f : this.factoriesMap.get(clazz).values()) {
            ids.add(f.getId());
        }
        return ids;
    }

    public void close() {
        for (Map<String, ProviderFactory> factories : this.factoriesMap.values()) {
            for (ProviderFactory factory : factories.values()) {
                factory.close();
            }
        }
    }
}

