/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelDuplicateException;
import org.keycloak.models.OAuthClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.models.utils.RepresentationToModel;
import org.keycloak.representations.idm.OAuthClientRepresentation;
import org.keycloak.services.resources.admin.OAuthClientResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RealmAuth;
import org.keycloak.services.resources.flows.Flows;

public class OAuthClientsResource {
    protected static final Logger logger = Logger.getLogger(RealmAdminResource.class);
    protected RealmModel realm;
    protected KeycloakSession session;
    private RealmAuth auth;

    public OAuthClientsResource(RealmModel realm, RealmAuth auth, KeycloakSession session) {
        this.auth = auth;
        this.realm = realm;
        this.session = session;
        auth.init(RealmAuth.Resource.CLIENT);
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    public List<OAuthClientRepresentation> getOAuthClients() {
        ArrayList<OAuthClientRepresentation> rep = new ArrayList<OAuthClientRepresentation>();
        List oauthModels = this.realm.getOAuthClients();
        boolean view = this.auth.hasView();
        for (OAuthClientModel oauth : oauthModels) {
            if (view) {
                rep.add(ModelToRepresentation.toRepresentation((OAuthClientModel)oauth));
                continue;
            }
            OAuthClientRepresentation client = new OAuthClientRepresentation();
            client.setName(oauth.getClientId());
            rep.add(client);
        }
        return rep;
    }

    @POST
    @Consumes(value={"application/json"})
    public Response createOAuthClient(@Context UriInfo uriInfo, OAuthClientRepresentation rep) {
        this.auth.requireManage();
        try {
            OAuthClientModel oauth = RepresentationToModel.createOAuthClient((OAuthClientRepresentation)rep, (RealmModel)this.realm);
            return Response.created((URI)uriInfo.getAbsolutePathBuilder().path(oauth.getClientId()).build(new Object[0])).build();
        }
        catch (ModelDuplicateException e) {
            return Flows.errors().exists("Client " + rep.getName() + " already exists");
        }
    }

    @Path(value="{clientId}")
    public OAuthClientResource getOAuthClient(@PathParam(value="clientId") String clientId) {
        this.auth.requireView();
        OAuthClientModel oauth = this.realm.getOAuthClient(clientId);
        if (oauth == null) {
            throw new NotFoundException("OAuth Client not found");
        }
        OAuthClientResource oAuthClientResource = new OAuthClientResource(this.realm, this.auth, oauth, this.session);
        ResteasyProviderFactory.getInstance().injectProperties((Object)oAuthClientResource);
        return oAuthClientResource;
    }
}

