/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.freemarker.Theme;
import org.keycloak.freemarker.ThemeProvider;
import org.keycloak.models.KeycloakSession;

@Path(value="/")
public class WelcomeResource {
    private static final Logger logger = Logger.getLogger(WelcomeResource.class);
    private static FileTypeMap mimeTypes = MimetypesFileTypeMap.getDefaultFileTypeMap();
    @Context
    private UriInfo uriInfo;
    @Context
    protected KeycloakSession session;

    @GET
    @Produces(value={"text/html"})
    public Response getWelcomePage() throws URISyntaxException {
        String requestUri = this.uriInfo.getRequestUri().toString();
        if (!requestUri.endsWith("/")) {
            return Response.seeOther((URI)new URI(requestUri + "/")).build();
        }
        return this.getResource("index.html");
    }

    @GET
    @Path(value="/welcome-content/{path}")
    @Produces(value={"text/html"})
    public Response getResource(@PathParam(value="path") String path) {
        try {
            Config.Scope config = Config.scope((String[])new String[]{"theme"});
            ThemeProvider themeProvider = (ThemeProvider)this.session.getProvider(ThemeProvider.class, "extending");
            Theme theme = themeProvider.getTheme(config.get("welcomeTheme"), Theme.Type.WELCOME);
            InputStream resource = theme.getResourceAsStream(path);
            if (resource != null) {
                String contentType = mimeTypes.getContentType(path);
                CacheControl cacheControl = new CacheControl();
                cacheControl.setNoTransform(false);
                cacheControl.setMaxAge(config.getInt("staticMaxAge", Integer.valueOf(-1)).intValue());
                Response.ResponseBuilder builder = Response.ok((Object)resource).type(contentType).cacheControl(cacheControl);
                return builder.build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            logger.warn((Object)"Failed to get theme resource", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

